<section class="hero">
    <div class="hero-content">
        <img
            src="<?= base_url('asset/website/img/'); ?>logo.png"
            alt="Logo Paroki Santa Maria Blitar"
            class="hero-logo"
        />
        <h1 class="hero-title">
            <span>Tentang Paroki</span><br> 
        </h1>
        <h4>
            Gereja Katolik Paroki Santa Maria Blitar
        </h4>
    </div>
</section>

<section class="history-section">
        <h1 class="section-title">Sejarah Paroki</h1>
        <div class="carousel-container">
            <div class="carousel">
                <!-- Generate 20 years from 2000 to 2019 -->
                <div class="carousel-item" data-year="2000">2000</div>
                <div class="carousel-item" data-year="2001">2001</div>
                <div class="carousel-item" data-year="2002">2002</div>
                <div class="carousel-item" data-year="2003">2003</div>
                <div class="carousel-item" data-year="2004">2004</div>
                <div class="carousel-item" data-year="2005">2005</div>
                <div class="carousel-item" data-year="2006">2006</div>
                <div class="carousel-item" data-year="2007">2007</div>
                <div class="carousel-item" data-year="2008">2008</div>
                <div class="carousel-item" data-year="2009">2009</div>
                <div class="carousel-item" data-year="2010">2010</div>
                <div class="carousel-item" data-year="2011">2011</div>
                <div class="carousel-item" data-year="2012">2012</div>
                <div class="carousel-item" data-year="2013">2013</div>
                <div class="carousel-item" data-year="2014">2014</div>
                <div class="carousel-item" data-year="2015">2015</div>
                <div class="carousel-item" data-year="2016">2016</div>
                <div class="carousel-item" data-year="2017">2017</div>
                <div class="carousel-item" data-year="2018">2018</div>
                <div class="carousel-item" data-year="2019">2019</div>
            </div>
        </div>
        <div class="history-content" id="history-content">
            <p>Pilih tahun untuk melihat sejarah paroki pada periode tersebut.</p>
        </div>
    </section>


<style>
.hero {
    background-image: url("<?php echo base_url('asset/website/img/bg4.jpg'); ?>");
    position: relative;
    height: 30rem;
    display: flex;
    justify-content: center;
    align-items: center;
    text-align: center;
    color: #fff;
    padding-top: 60px;
    background-size: cover;
    background-position: center;
}



        .history-section {
            padding: 60px 20px;
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .section-title {
            font-size: 2.5rem;
    font-weight: 700;
    color:  var(--color-primary) ;
    margin-bottom: 10px;
    text-transform: uppercase;
    letter-spacing: 1px;
        }

        .carousel-container {
            position: relative;
            width: 650px; /* 5 items * (120px width + 10px margin) + padding */
            margin: 0 auto;
            margin-bottom: 50px;
            overflow: hidden;
            touch-action: pan-x; /* Allow horizontal touch scrolling */
        }

        .carousel {
            display: flex;
            transition: transform 0.6s cubic-bezier(0.68, -0.55, 0.265, 1.55); /* Smooth, bouncy animation */
        }

        .carousel.dragging {
            transition: none; /* Disable transition during drag */
        }

        .carousel-item {
            flex: 0 0 120px;
            height: 70px;
            background:   var(--color-primary);
            color: #f4f1e8;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.4rem;
            font-weight: 400;
            margin: 0 5px;
            cursor: pointer;
            border-radius: 10px;
            transition: all 0.3s ease, opacity 0.3s ease;
            opacity: 0.8;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        }

        .carousel-item:hover {
            background:rgb(207, 135, 94);
            transform: translateY(-2px);
            opacity: 0.9;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }

        .carousel-item.active {
            background:rgb(59, 26, 6);
            color: #f4f1e8;
            transform: scale(1.1);
            opacity: 1;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }

        .carousel-item.entering {
            opacity: 0;
            transform: translateY(10px);
            transition: opacity 0.3s ease, transform 0.3s ease;
        }

        .carousel-item.entering.active {
            opacity: 1;
            transform: scale(1.1);
        }

        .history-content {
            background: #f4f1e8;
            border: 1px solid rgba(155, 72, 25, 0.2);
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            min-height: 200px;
            width: 100%;
            max-width: 650px;
            opacity: 0;
            transform: translateY(20px);
            animation: fadeIn 0.5s forwards;
            font-size: 1.1rem;
            line-height: 1.6;
            color: #252525;
        }

        @keyframes fadeIn {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Responsive Design */
        @media (max-width: 1024px) {
            .section-title {
                font-size: 2.4rem;
            }

            .carousel-container,
            .history-content {
                width: 550px; /* 5 items * (100px width + 10px margin) */
            }

            .carousel-item {
                flex: 0 0 100px;
                height: 60px;
                font-size: 1.2rem;
            }

            .history-content {
                padding: 30px;
                font-size: 1rem;
            }
        }

        @media (max-width: 790px) {
            .carousel-container,
            .history-content {
                width: 450px; /* 5 items * (80px width + 10px margin) */
            }

            .carousel-item {
                flex: 0 0 80px;
                height: 50px;
                font-size: 1rem;
            }

            .section-title {
                font-size: 2rem;
                margin-bottom: 30px;
            }

            .history-content {
                padding: 20px;
                font-size: 0.9rem;
            }
        }

        @media (max-width: 480px) {
            .history-section {
                padding: 30px 10px;
            }

            .section-title {
                font-size: 1.6rem;
                margin-bottom: 20px;
            }

            .carousel-container,
            .history-content {
                width: 350px; /* 5 items * (60px width + 10px margin) */
            }

            .carousel-item {
                flex: 0 0 60px;
                height: 40px;
                font-size: 0.9rem;
            }

            .history-content {
                padding: 15px;
                font-size: 0.8rem;
            }
        }
    </style>

<script>
        const carousel = document.querySelector('.carousel');
        const items = document.querySelectorAll('.carousel-item');
        const content = document.querySelector('#history-content');
        let currentIndex = 2; // Start with 2002 in center
        let isDragging = false;
        let startX = 0;
        let currentTranslate = 0;
        let prevTranslate = 0;

        // Sample history data
        const historyData = {
            2000: 'Tahun 2000: Paroki memulai program pendidikan anak.',
            2001: 'Tahun 2001: Renovasi kapel selesai.',
            2002: 'Tahun 2002: Pembentukan kelompok paduan suara paroki.',
            2003: 'Tahun 2003: Perayaan ulang tahun paroki ke-25.',
            2004: 'Tahun 2004: Pembangunan aula serbaguna.',
            2005: 'Tahun 2005: Program bantuan sosial untuk masyarakat.',
            2006: 'Tahun 2006: Penambahan fasilitas perpustakaan.',
            2007: 'Tahun 2007: Peluncuran website resmi paroki.',
            2008: 'Tahun 2008: Penyelenggaraan retret tahunan.',
            2009: 'Tahun 2009: Pembentukan kelompok katekese anak.',
            2010: 'Tahun 2010: Renovasi besar-besaran gereja.',
            2011: 'Tahun 2011: Program beasiswa untuk pelajar.',
            2012: 'Tahun 2012: Pembentukan kelompok karitatif.',
            2013: 'Tahun 2013: Perayaan Natal bersama komunitas.',
            2014: 'Tahun 2014: Penambahan fasilitas parkir.',
            2015: 'Tahun 2015: Program pelatihan kepemimpinan muda.',
            2016: 'Tahun 2016: Penyelenggaraan seminar keagamaan.',
            2017: 'Tahun 2017: Pembangunan taman doa.',
            2018: 'Tahun 2018: Program bakti sosial lingkungan.',
            2019: 'Tahun 2019: Perayaan Paskah dengan drama musikal.'
        };

        function updateCarousel(animate = true) {
            const itemWidth = items[0].offsetWidth + 10; // Width + margin
            const containerWidth = carousel.parentElement.offsetWidth;
            const visibleItems = 5;

            // Reset active state
            items.forEach(item => {
                item.classList.remove('active', 'entering');
            });

            // Calculate transform to center the active item
            const offset = -(currentIndex * itemWidth - (containerWidth - itemWidth) / 2);

            // Update active item and content
            items[currentIndex].classList.add('active');
            content.innerHTML = `<p>${historyData[items[currentIndex].dataset.year]}</p>`;

            // Apply transform
            if (animate) {
                carousel.classList.remove('dragging');
                carousel.style.transform = `translateX(${offset}px)`;
            } else {
                carousel.classList.add('dragging');
                carousel.style.transform = `translateX(${currentTranslate}px)`;
            }

            // Apply entering animation for visible items
            const startIndex = Math.max(0, currentIndex - 2);
            const endIndex = Math.min(items.length - 1, currentIndex + 2);
            for (let i = startIndex; i <= endIndex; i++) {
                const item = items[i];
                item.classList.add('entering');
                setTimeout(() => {
                    item.style.opacity = '0.8';
                    item.style.transform = i === currentIndex ? 'scale(1.1)' : 'translateY(0)';
                }, 10);
            }
        }

        // Dragging functionality
        function startDragging(e) {
            isDragging = true;
            carousel.classList.add('dragging');
            startX = e.type.includes('mouse') ? e.pageX : e.touches[0].clientX;
            prevTranslate = currentTranslate;
        }

        function drag(e) {
            if (isDragging) {
                const currentX = e.type.includes('mouse') ? e.pageX : e.touches[0].clientX;
                currentTranslate = prevTranslate + (currentX - startX);
                carousel.style.transform = `translateX(${currentTranslate}px)`;
            }
        }

        function stopDragging(e) {
            if (isDragging) {
                isDragging = false;
                const itemWidth = items[0].offsetWidth + 10;
                const movedBy = currentTranslate - prevTranslate;

                // Calculate new index based on swipe distance
                const itemsMoved = Math.round(movedBy / itemWidth);
                currentIndex = Math.max(0, Math.min(items.length - 1, currentIndex - itemsMoved));

                updateCarousel(true);
            }
        }

        // Event listeners for drag
        carousel.addEventListener('mousedown', startDragging);
        carousel.addEventListener('mousemove', drag);
        carousel.addEventListener('mouseup', stopDragging);
        carousel.addEventListener('mouseleave', () => {
            if (isDragging) stopDragging();
        });

        // Touch events
        carousel.addEventListener('touchstart', startDragging);
        carousel.addEventListener('touchmove', drag);
        carousel.addEventListener('touchend', stopDragging);

        // Click to select year
        items.forEach(item => {
            item.addEventListener('click', () => {
                const newIndex = Array.from(items).indexOf(item);
                if (newIndex !== currentIndex) {
                    currentIndex = newIndex;
                    updateCarousel(true);
                }
            });
        });

        // Initialize
        updateCarousel(true);

        // Update on window resize
        window.addEventListener('resize', () => updateCarousel(true));
    </script>