<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>
    <div class="row">
        <div class="col-lg">
            <!-- Tombol Add New Lingkungan/Stasi -->
            <a href="" class="btn btn-primary mb-3" data-toggle="modal" data-target="#newLingkunganModal">Add New Lingkungan/Stasi</a>

            <!-- Form Pencarian dan Filter Status -->
            <form method="get" action="<?= base_url('d_lingkungan'); ?>" class="mb-3">
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="Cari lingkungan/stasi..." value="<?= isset($_GET['search']) ? html_escape($_GET['search']) : ''; ?>">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">Search</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select name="status" class="form-control" onchange="this.form.submit()">
                            <option value="all" <?= isset($_GET['status']) && $_GET['status'] == 'all' ? 'selected' : ''; ?>>All</option>
                            <option value="pending" <?= isset($_GET['status']) && $_GET['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                            <option value="public" <?= isset($_GET['status']) && $_GET['status'] == 'public' ? 'selected' : ''; ?>>Public</option>
                        </select>
                    </div>
                </div>
            </form>

            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Nama Stasi</th>
                        <th scope="col">Wilayah</th>
                        <th scope="col">Nama Ketua</th>
                        <th scope="col">Status</th>
                        <th scope="col">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php foreach ($lingkungan as $lingk) : ?>
                    <tr>
                        <th scope="row" style="cursor: pointer;" data-toggle="modal" data-target="#detailLingkunganModal<?= $lingk['id']; ?>"><?= $i; ?></th>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailLingkunganModal<?= $lingk['id']; ?>">
                            <?php
                            $nama_stasi = $lingk['kategori'] == 'Lingkungan' 
                                ? $lingk['kategori'] . ' ' . $lingk['nama_pelindung']
                                : $lingk['kategori'] . ' ' . $lingk['nama_pelindung'] . ' ' . $lingk['lokasi'];
                            echo strlen($nama_stasi) > 50 ? html_escape(substr($nama_stasi, 0, 50)) . '...' : html_escape($nama_stasi);
                            ?>
                        </td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailLingkunganModal<?= $lingk['id']; ?>"><?= html_escape($lingk['wilayah']); ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailLingkunganModal<?= $lingk['id']; ?>"><?= html_escape($lingk['nama_ketua']); ?></td>
                        <td>
                            <?php if ($user['role_id'] == 1) : ?>
                                <?php if ($lingk['role'] == 0) : ?>
                                    <a href="<?= base_url('d_lingkungan/publish/') . $lingk['id']; ?>" class="badge badge-warning" onclick="return confirm('Apakah Anda yakin ingin mempublikasikan data ini?')">Pending</a>
                                <?php elseif ($lingk['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php else : ?>
                                <?php if ($lingk['role'] == 0) : ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php elseif ($lingk['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?= base_url('d_lingkungan/edit/') . $lingk['id']; ?>" class="badge badge-success">Edit</a>
                            <a href="<?= base_url('d_lingkungan/delete/') . $lingk['id']; ?>" class="badge badge-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')">Delete</a>
                        </td>
                    </tr>

                    <!-- Modal Detail Lingkungan -->
                    <div class="modal fade" id="detailLingkunganModal<?= $lingk['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="detailLingkunganModalLabel<?= $lingk['id']; ?>" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="modal-title w-100" id="detailLingkunganModalLabel<?= $lingk['id']; ?>">
                                        <?= html_escape($lingk['kategori'] . ' ' . $lingk['nama_pelindung']); ?>
                                    </h2>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <p class="text-muted small mb-3">
                                        Lokasi: <?= html_escape($lingk['lokasi']); ?> | 
                                        Wilayah: <?= html_escape($lingk['wilayah']); ?> | 
                                        Ketua: <?= html_escape($lingk['nama_ketua']); ?> (ID: <?= html_escape($lingk['id_ketua']); ?>)
                                    </p>
                                    <?php if (!empty($lingk['gambar_gereja'])) : ?>
                                        <img src="<?= base_url('asset/img/lingkungan/') . $lingk['gambar_gereja']; ?>" class="img-fluid mb-3" alt="Gambar Gereja">
                                    <?php endif; ?>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal Tambah Lingkungan/Stasi -->
    <div class="modal fade" id="newLingkunganModal" tabindex="-1" role="dialog" aria-labelledby="newLingkunganModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newLingkunganModalLabel">Tambah Lingkungan/Stasi Baru</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form action="<?= base_url('d_lingkungan/tambah'); ?>" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="kategori">Kategori</label>
                            <select class="form-control" id="kategori" name="kategori" required>
                                <option value="Paroki">Paroki</option>
                                <option value="Stasi">Stasi</option>
                                <option value="Lingkungan">Lingkungan</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="nama_pelindung">Nama Pelindung</label>
                            <input type="text" class="form-control" id="nama_pelindung" name="nama_pelindung" placeholder="Masukkan nama pelindung" required>
                        </div>
                        <div class="form-group">
                            <label for="lokasi">Lokasi</label>
                            <input type="text" class="form-control" id="lokasi" name="lokasi" placeholder="Masukkan lokasi" required>
                        </div>
                        <div class="form-group">
                            <label for="wilayah">Wilayah</label>
                            <select class="form-control" id="wilayah" name="wilayah">
                                <option value="">-- Pilih Wilayah --</option>
                                <?php for ($i = 1; $i <= 10; $i++) : ?>
                                    <option value="Wilayah <?= $i; ?>">Wilayah <?= $i; ?></option>
                                <?php endfor; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="nama_ketua">Nama Ketua</label>
                            <input type="text" class="form-control" id="nama_ketua" name="nama_ketua" placeholder="Masukkan nama ketua" required>
                        </div>
                        <div class="form-group">
                            <label for="id_ketua">ID Ketua</label>
                            <input type="number" class="form-control" id="id_ketua" name="id_ketua" placeholder="Masukkan ID ketua">
                        </div>
                        <div class="form-group">
                            <label for="gambar_gereja">Gambar Gereja (opsional)</label>
                            <input type="file" class="form-control-file" id="gambar_gereja" name="gambar_gereja">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>