<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>

    <div class="row">
        <div class="col-lg">
            <!-- Tombol Add New Lagu dan Add Kategori -->
            <a href="" class="btn btn-primary mb-3" data-toggle="modal" data-target="#newLaguModal">Add New Lagu</a>

            <!-- Form Pencarian dan Filter Status -->
            <form method="get" action="<?= base_url('d_kumpulan_lagu'); ?>" class="mb-3">
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="Cari lagu..." value="<?= isset($_GET['search']) ? $_GET['search'] : ''; ?>">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">Search</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select name="status" class="form-control" onchange="this.form.submit()">
                            <option value="all" <?= isset($_GET['status']) && $_GET['status'] == 'all' ? 'selected' : ''; ?>>All</option>
                            <option value="pending" <?= isset($_GET['status']) && $_GET['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                            <option value="public" <?= isset($_GET['status']) && $_GET['status'] == 'public' ? 'selected' : ''; ?>>Public</option>
                        </select>
                    </div>
                </div>
            </form>

            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Judul Lagu</th>
                        <th scope="col">Jenis Lagu</th>
                        <th scope="col">Kategori Lagu</th>
                        <th scope="col">Status</th>
                        <th scope="col">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php foreach ($lagu as $l) : ?>
                    <tr>
                        <th scope="row" style="cursor: pointer;" data-toggle="modal" data-target="#detailLaguModal<?= $l['id']; ?>"><?= $i; ?></th>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailLaguModal<?= $l['id']; ?>"><?= $l['judul_lagu']; ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailLaguModal<?= $l['id']; ?>"><?= $l['jenis_lagu']; ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailLaguModal<?= $l['id']; ?>"><?= $l['kategori_lagu']; ?></td>
                        <td>
                            <?php if ($user['role_id'] == 1) : ?>
                                <?php if ($l['role'] == 0) : ?>
                                    <a href="<?= base_url('d_kumpulan_lagu/publish/') . $l['id']; ?>" class="badge badge-warning" onclick="return confirm('Apakah Anda yakin ingin mempublikasikan lagu ini?')">Pending</a>
                                <?php elseif ($l['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php else : ?>
                                <?php if ($l['role'] == 0) : ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php elseif ($l['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?= base_url('d_kumpulan_lagu/edit/') . $l['id']; ?>" class="badge badge-success">Edit</a>
                            <a href="<?= base_url('d_kumpulan_lagu/delete/') . $l['id']; ?>" class="badge badge-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus lagu ini?')">Delete</a>
                        </td>
                    </tr>

                    <!-- Modal Detail Lagu -->
                    <div class="modal fade" id="detailLaguModal<?= $l['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="detailLaguModalLabel<?= $l['id']; ?>" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="modal-title w-100" id="detailLaguModalLabel<?= $l['id']; ?>"><?= $l['judul_lagu']; ?></h2>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <p><strong>Jenis Lagu:</strong></p>
                                            <p><strong>Kategori Lagu:</strong></p>
                                            <p><strong>Deskripsi:</strong></p>
                                            <p><strong>File PDF:</strong></p>
                                            <p><strong>Status:</strong></p>
                                        </div>
                                        <div class="col-md-9">
                                            <p><?= $l['jenis_lagu']; ?></p>
                                            <p><?= $l['kategori_lagu']; ?></p>
                                            <p><?= nl2br($l['deskripsi_lagu']); ?></p>
                                            <p><a href="<?= base_url('asset/pdf/lagu/' . $l['pdf']); ?>" target="_blank" class="btn btn-sm btn-primary">Lihat PDF</a></p>
                                            <p><?= $l['role'] == 0 ? 'Pending' : 'Public'; ?></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal Tambah Lagu -->
    <div class="modal fade" id="newLaguModal" tabindex="-1" role="dialog" aria-labelledby="newLaguModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newLaguModalLabel">Add New Lagu</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form action="<?= base_url('d_kumpulan_lagu'); ?>" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="jenis_lagu">Jenis Lagu <span class="text-danger">*</span></label>
                            <select class="form-control" id="jenis_lagu" name="jenis_lagu" required>
                                <option value="">Pilih Jenis Lagu</option>
                                <option value="Liturgi">Liturgi</option>
                                <option value="Non Liturgi">Non Liturgi</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="kategori_lagu">Kategori Lagu <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="kategori_lagu" name="kategori_lagu" placeholder="Contoh: #Pop, #Rohani; #Klasik" required>
                            <div id="kategori_suggestions" class="dropdown-menu" style="width: 100%; max-height: 200px; overflow-y: auto;"></div>
                            <small class="form-text text-muted">Gunakan # di awal kategori, pisahkan dengan , atau ; untuk kategori tambahan.</small>
                        </div>
                        <div class="form-group">
                            <label for="judul_lagu">Judul Lagu <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="judul_lagu" name="judul_lagu" required>
                        </div>
                        <div class="form-group">
                            <label for="deskripsi_lagu">Deskripsi Lagu</label>
                            <textarea class="form-control" id="deskripsi_lagu" name="deskripsi_lagu" rows="5"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="pdf">Upload PDF <span class="text-danger">*</span></label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="pdf" name="pdf" accept=".pdf" required>
                                <label class="custom-file-label" for="pdf">Choose file</label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Tambah Kategori -->
    <?php if ($user['role_id'] == 1) : ?>
    <div class="modal fade" id="newKategoriModal" tabindex="-1" role="dialog" aria-labelledby="newKategoriModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newKategoriModalLabel">Tambah Kategori Baru</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form action="<?= base_url('d_kumpulan_lagu/add_kategori'); ?>" method="post">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="kategori">Kategori <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="kategori_add" name="kategori" placeholder="Contoh: #Pop, #Rohani; #Klasik" required>
                            <div id="kategori_add_suggestions" class="dropdown-menu" style="width: 100%; max-height: 200px; overflow-y: auto;"></div>
                            <small class="form-text text-muted">Gunakan # di awal kategori, pisahkan dengan , atau ; untuk kategori tambahan.</small>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<!-- /.container-fluid -->

<style>
    .dropdown-menu.show {
        display: block;
    }
</style>

<script>
    $('.custom-file-input').on('change', function() {
        let fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').addClass("selected").html(fileName);
    });

    // Fungsi untuk menampilkan saran kategori
    function showSuggestions(inputId, suggestionId) {
        const input = document.getElementById(inputId);
        const suggestions = document.getElementById(suggestionId);

        input.addEventListener('input', function() {
            const value = this.value.trim();
            suggestions.innerHTML = '';

            if (value.startsWith('#')) {
                const searchTerm = value.substring(1).toLowerCase(); // Hilangkan # untuk pencarian
                fetch('<?= base_url('d_kumpulan_lagu/get_kategori_suggestions'); ?>?q=' + encodeURIComponent(searchTerm))
                    .then(response => response.json())
                    .then(data => {
                        if (data.length > 0) {
                            data.forEach(item => {
                                const div = document.createElement('div');
                                div.className = 'dropdown-item';
                                div.style.cursor = 'pointer';
                                div.textContent = '#' + item;
                                div.addEventListener('click', function() {
                                    const currentValue = input.value.split(/[,;]/).map(v => v.trim());
                                    currentValue[currentValue.length - 1] = '#' + item;
                                    input.value = currentValue.join(', ') + ', ';
                                    suggestions.innerHTML = '';
                                    suggestions.classList.remove('show');
                                });
                                suggestions.appendChild(div);
                            });
                            suggestions.classList.add('show');
                        } else {
                            suggestions.classList.remove('show');
                        }
                    });
            } else {
                suggestions.classList.remove('show');
            }
        });

        // Sembunyikan saran saat klik di luar
        document.addEventListener('click', function(e) {
            if (!input.contains(e.target) && !suggestions.contains(e.target)) {
                suggestions.classList.remove('show');
            }
        });
    }

    // Inisialisasi saran untuk kedua input
    showSuggestions('kategori_lagu', 'kategori_suggestions');
    showSuggestions('kategori_add', 'kategori_add_suggestions');
</script>