<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>

    <div class="row">
        <div class="col-lg">
            <!-- Tombol Add New Kategorial -->
            <a href="" class="btn btn-primary mb-3" data-toggle="modal" data-target="#newKategorialModal">Add New Kategorial</a>

            <!-- Form Pencarian dan Filter Status -->
            <form method="get" action="<?= base_url('d_kategorial'); ?>" class="mb-3">
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="Cari kategorial..." value="<?= isset($_GET['search']) ? $_GET['search'] : ''; ?>">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">Search</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select name="status" class="form-control" onchange="this.form.submit()">
                            <option value="all" <?= isset($_GET['status']) && $_GET['status'] == 'all' ? 'selected' : ''; ?>>All</option>
                            <option value="pending" <?= isset($_GET['status']) && $_GET['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                            <option value="public" <?= isset($_GET['status']) && $_GET['status'] == 'public' ? 'selected' : ''; ?>>Public</option>
                        </select>
                    </div>
                </div>
            </form>

            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Judul</th>
                        <th scope="col">Keterangan</th>
                        <th scope="col">Status</th>
                        <th scope="col">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php foreach ($kategorial as $k) : ?>
                    <tr>
                        <th scope="row" style="cursor: pointer;" data-toggle="modal" data-target="#detailKategorialModal<?= $k['id']; ?>"><?= $i; ?></th>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailKategorialModal<?= $k['id']; ?>"><?= $k['judul']; ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailKategorialModal<?= $k['id']; ?>"><?= $k['keterangan']; ?></td>
                        <td>
                            <?php if ($user['role_id'] == 1) : ?>
                                <?php if ($k['role'] == 0) : ?>
                                    <a href="<?= base_url('d_kategorial/publish/') . $k['id']; ?>" class="badge badge-warning" onclick="return confirm('Apakah Anda yakin ingin mempublikasikan data ini?')">Pending</a>
                                <?php elseif ($k['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php else : ?>
                                <?php if ($k['role'] == 0) : ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php elseif ($k['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?= base_url('d_kategorial/edit/') . $k['id']; ?>" class="badge badge-success">Edit</a>
                            <a href="<?= base_url('d_kategorial/delete/') . $k['id']; ?>" class="badge badge-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')">Delete</a>
                        </td>
                    </tr>

                    <!-- Modal Detail Kategorial -->
                    <div class="modal fade" id="detailKategorialModal<?= $k['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="detailKategorialModalLabel<?= $k['id']; ?>" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h2 class="modal-title w-100" id="detailKategorialModalLabel<?= $k['id']; ?>"><?= $k['judul']; ?></h2>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                                <div class="modal-body text-center">
                                    <?php if (!empty($k['logo'])) : ?>
                                        <img src="<?= base_url('asset/img/kategorial/') . $k['logo']; ?>" class="img-fluid mb-3" alt="<?= $k['judul']; ?>" style="max-width: 300px; height: 300px; object-fit: cover;">
                                    <?php endif; ?>
                                    <div class="text-left">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <p><strong>Keterangan:</strong></p>
                                                <p><strong>Deskripsi:</strong></p>
                                            </div>
                                            <div class="col-md-9">
                                                <p><?= $k['keterangan']; ?></p>
                                                <p><?= nl2br($k['deskripsi']); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal Tambah Kategorial -->
    <div class="modal fade" id="newKategorialModal" tabindex="-1" role="dialog" aria-labelledby="newKategorialModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newKategorialModalLabel">Add New Kategorial</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form action="<?= base_url('d_kategorial'); ?>" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="judul">Judul <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="judul" name="judul" required>
                        </div>
                        <div class="form-group">
                            <label for="keterangan">Keterangan (max 50 karakter) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="keterangan" name="keterangan" maxlength="50" required>
                        </div>
                        <div class="form-group">
                            <label for="deskripsi">Deskripsi</label>
                            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5"></textarea>
                        </div>
                        <div class="custom-file">
                            <label for="logo">Upload Logo</label>
                            <input type="file" class="custom-file-input" id="logo" name="logo">
                            <label class="custom-file-label" for="logo">Choose file</label>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- /.container-fluid -->

<script>
    $('.custom-file-input').on('change', function() {
        let fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').addClass("selected").html(fileName);
    });
</script>