<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>
    <div class="row">
        <div class="col-lg">
            <!-- Tombol Add New Artikel dan Add Kategori -->
            <a href="" class="btn btn-primary mb-3" data-toggle="modal" data-target="#newArtikelModal">Add New Artikel</a>
            <?php if (isset($user['role_id']) && $user['role_id'] == 1) : ?>
                <a href="" class="btn btn-success mb-3" data-toggle="modal" data-target="#newKategoriModal">Add Kategori</a>
            <?php endif; ?>

            <!-- Form Pencarian dan Filter Status -->
            <form method="get" action="<?= base_url('d_artikel'); ?>" class="mb-3">
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="Cari artikel..." value="<?= isset($_GET['search']) ? html_escape($_GET['search']) : ''; ?>">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">Search</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select name="status" class="form-control" onchange="this.form.submit()">
                            <option value="all" <?= isset($_GET['status']) && $_GET['status'] == 'all' ? 'selected' : ''; ?>>All</option>
                            <option value="pending" <?= isset($_GET['status']) && $_GET['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                            <option value="public" <?= isset($_GET['status']) && $_GET['status'] == 'public' ? 'selected' : ''; ?>>Public</option>
                        </select>
                    </div>
                </div>
            </form>

            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Judul</th>
                        <th scope="col">Isi</th>
                        <th scope="col">Kategori</th>
                        <th scope="col">Tanggal</th>
                        <th scope="col">Status</th>
                        <th scope="col">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php foreach ($artikel as $art) : ?>
                    <tr>
                        <!-- Area klik untuk modal dari Nomor hingga Tanggal -->
                        <th scope="row" style="cursor: pointer;" data-toggle="modal" data-target="#detailArtikelModal<?= $art['id']; ?>"><?= $i; ?></th>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailArtikelModal<?= $art['id']; ?>">
                            <?php
                            if (strlen($art['judul']) > 20) {
                                echo html_escape(substr($art['judul'], 0, 20)) . "...";
                            } else {
                                echo html_escape($art['judul']);
                            }
                            ?>
                        </td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailArtikelModal<?= $art['id']; ?>">
                            <?php
                            if (strlen($art['isi']) > 20) {
                                echo nl2br(html_escape(substr($art['isi'], 0, 30))) . "...";
                            } else {
                                echo nl2br(html_escape($art['isi']));
                            }
                            ?>
                        </td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailArtikelModal<?= $art['id']; ?>"><?= html_escape($art['kategori']); ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailArtikelModal<?= $art['id']; ?>"><?= html_escape($art['tanggal']); ?></td>
                        <!-- Kolom Status dan Action tidak memicu modal -->
                        <td>
                            <?php if ($user['role_id'] == 1) : ?>
                                <?php if ($art['role'] == 0) : ?>
                                    <a href="<?= base_url('d_artikel/publish/') . $art['id']; ?>" class="badge badge-warning" onclick="return confirm('Apakah Anda yakin ingin mempublikasikan artikel ini?')">Pending</a>
                                <?php elseif ($art['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php else : ?>
                                <?php if ($art['role'] == 0) : ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php elseif ($art['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?= base_url('d_artikel/editartikel/') . $art['id']; ?>" class="badge badge-success">Edit</a>
                            <a href="<?= base_url('d_artikel/delete/') . $art['id']; ?>" class="badge badge-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus artikel ini?')">Delete</a>
                        </td>
                    </tr>

                    <!-- Modal Detail Artikel -->
                    <div class="modal fade" id="detailArtikelModal<?= $art['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="detailArtikelModalLabel<?= $art['id']; ?>" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h2 class="modal-title w-100" id="detailArtikelModalLabel<?= $art['id']; ?>"><?= html_escape($art['judul']); ?></h2>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <p class="text-muted small mb-3">
                    <?= html_escape($art['kategori']); ?> | 
                    <?php echo isset($art['tanggal']) ? date('d F Y H:i', strtotime($art['tanggal'])) : 'Tanggal tidak tersedia'; ?> | 
                    <?php echo isset($art['penulis']) ? html_escape($art['penulis']) : html_escape($user['name']); ?>
                </p>
                <?php if (!empty($art['linkg1'])) : ?>
                    <img src="<?= base_url('asset/img/artikel/') . $art['linkg1']; ?>" class="img-fluid mb-3" alt="Gambar Artikel">
                <?php endif; ?>
                <div class="artikel-isi">
                    <?= nl2br(html_escape($art['isi'])); ?>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php $i++; ?>
<?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal Tambah Artikel -->
    <div class="modal fade" id="newArtikelModal" tabindex="-1" role="dialog" aria-labelledby="newArtikelModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newArtikelModalLabel">Tambah Artikel Baru</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form action="<?= base_url('d_artikel'); ?>" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="judul">Judul</label>
                            <input type="text" class="form-control" id="judul" name="judul" placeholder="Masukkan judul artikel" required>
                        </div>
                        <div class="form-group">
                            <label for="isi">Isi</label>
                            <textarea class="form-control" id="isi" name="isi" placeholder="Masukkan isi artikel" rows="10" required></textarea>
                        </div>
                        <div class="form-group">
                            <label for="kategori">Kategori</label>
                            <select class="form-control" id="kategori" name="kategori" required>
                                <?php foreach ($kategori as $kat) : ?>
                                    <option value="<?= html_escape($kat['nama']); ?>"><?= html_escape($kat['nama']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="isi">Tag #</label>
                            <textarea class="form-control" id="tag" name="tag" placeholder="masukkan Tag Kategori..."></textarea>
                        </div>
                        <div class="form-group">
                            <label for="gambar">Gambar (opsional)</label>
                            <input type="file" class="form-control-file" id="gambar" name="gambar">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Tambah Kategori -->
    <?php if (isset($user['role_id']) && $user['role_id'] == 1) : ?>
    <div class="modal fade" id="newKategoriModal" tabindex="-1" role="dialog" aria-labelledby="newKategoriModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newKategoriModalLabel">Tambah Kategori Baru</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form action="<?= base_url('d_artikel/add_kategori'); ?>" method="post">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="kategori">Kategori</label>
                            <input type="text" class="form-control" id="kategori" name="kategori" placeholder="Masukkan nama kategori" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>