<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pelayan_pastoral_model extends CI_Model {

    public function getPelayan($search = null, $status = null) {
        $this->db->order_by('id', 'DESC');

        if ($search) {
            $this->db->like('nama_lengkap', $search);
            $this->db->or_like('jabatan', $search);
            $this->db->or_like('tarekat', $search);
            $this->db->or_like('tempat_lahir', $search);
            $this->db->or_like('deskripsi', $search);
            $this->db->or_like('tempat_tahbisan', $search);
        }

        if ($status == 'pending') {
            $this->db->where('role', 0);
        } elseif ($status == 'public') {
            $this->db->where('role', 1);
        }

        return $this->db->get('pelayan_pastoral_db')->result_array();
    }

    public function getPelayanByUser($user_id, $search = null, $status = null) {
        $this->db->where('user_id', $user_id);
        $this->db->order_by('id', 'DESC');

        if ($search) {
            $this->db->like('nama_lengkap', $search);
            $this->db->or_like('jabatan', $search);
            $this->db->or_like('tarekat', $search);
            $this->db->or_like('tempat_lahir', $search);
            $this->db->or_like('deskripsi', $search);
            $this->db->or_like('tempat_tahbisan', $search);
        }

        if ($status == 'pending') {
            $this->db->where('role', 0);
        } elseif ($status == 'public') {
            $this->db->where('role', 1);
        }

        return $this->db->get('pelayan_pastoral_db')->result_array();
    }
}