<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class D_Sejarah extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('session');

        if (!$this->session->userdata('email')) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Silakan login terlebih dahulu!</div>');
            redirect('auth');
        }
    }

    public function index() {
        $data['title'] = 'Sejarah';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

        if (!$data['user']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengguna tidak ditemukan! Silakan login ulang.</div>');
            redirect('auth');
        }

        $data['search'] = $this->input->get('search', true);
        $data['status'] = $this->input->get('status', true);
        $this->load->model('Sejarah_model', 'sejarah');
        $data['kategori_list'] = $this->sejarah->getKategoriLingkungan();

        if ($data['user']['role_id'] == 1) {
            $data['sejarah'] = $this->sejarah->getSejarah($data['search'], $data['status'] === 'all' ? null : $data['status']);
        } else {
            $data['sejarah'] = $this->sejarah->getSejarahByUser($data['user']['id'], $data['search'], $data['status'] === 'all' ? null : $data['status']);
        }

        $this->load->view('template/user_header', $data);
        $this->load->view('template/sidebar', $data);
        $this->load->view('template/topbar', $data);
        $this->load->view('d_sejarah/index', $data);
        $this->load->view('template/user_footer');
    }

    public function tambah() {
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

        $this->form_validation->set_rules('tahun', 'Tahun', 'required');
        $this->form_validation->set_rules('kategori', 'Kategori', 'required');
        $this->form_validation->set_rules('isi', 'Isi', 'required');

        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Semua field wajib diisi kecuali gambar!</div>');
            redirect('d_sejarah');
        } else {
            $upload_image = $_FILES['gambar_sejarah']['name'];
            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_gambar = basename($upload_image, '.' . $ext);
                $nama_gambar_baru = $nama_gambar . '_' . time() . '.' . $ext;

                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048;
                $config['upload_path'] = './asset/img/sejarah/';
                $config['file_name'] = $nama_gambar_baru;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('gambar_sejarah')) {
                    $new_img = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah gambar: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_sejarah');
                }
            } else {
                $new_img = '';
            }

            $data_insert = [
                'tanggal_penulisan' => date('Y-m-d'),
                'tahun' => $this->input->post('tahun', true),
                'kategori' => $this->input->post('kategori', true),
                'isi' => $this->input->post('isi', true),
                'role' => 0,
                'gambar_sejarah' => $new_img
            ];
            $this->db->insert('sejarah_db', $data_insert);

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data Sejarah berhasil ditambahkan!</div>');
            redirect('d_sejarah');
        }
    }

    public function publish($id) {
        $user = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        if ($user['role_id'] != 1) {
            redirect('d_sejarah');
        }

        $this->db->set('role', 1);
        $this->db->where('id', $id);
        $this->db->update('sejarah_db');

        $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data berhasil dipublikasikan!</div>');
        redirect('d_sejarah');
    }

    public function delete($id) {
        $sejarah = $this->db->get_where('sejarah_db', ['id' => $id])->row_array();

        if ($sejarah) {
            if ($sejarah['gambar_sejarah'] && file_exists(FCPATH . 'asset/img/sejarah/' . $sejarah['gambar_sejarah'])) {
                unlink(FCPATH . 'asset/img/sejarah/' . $sejarah['gambar_sejarah']);
            }

            $this->db->where('id', $id);
            $this->db->delete('sejarah_db');

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data berhasil dihapus!</div>');
        } else {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Data tidak ditemukan!</div>');
        }

        redirect('d_sejarah');
    }

    public function edit($id) {
        $data['title'] = 'Edit Sejarah';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

        if (!$data['user']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengguna tidak ditemukan! Silakan login ulang.</div>');
            redirect('auth');
        }

        $this->load->model('Sejarah_model', 'sejarah');
        $data['sejarah'] = $this->sejarah->getSejarahById($id);
        $data['kategori_list'] = $this->sejarah->getKategoriLingkungan();

        if (!$data['sejarah']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Data tidak ditemukan!</div>');
            redirect('d_sejarah');
        }

        $this->form_validation->set_rules('tahun', 'Tahun', 'required');
        $this->form_validation->set_rules('kategori', 'Kategori', 'required');
        $this->form_validation->set_rules('isi', 'Isi', 'required');

        if ($this->form_validation->run() == false) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_sejarah/edit', $data);
            $this->load->view('template/user_footer');
        } else {
            $upload_image = $_FILES['gambar_sejarah']['name'];

            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_gambar = basename($upload_image, '.' . $ext);
                $nama_gambar_baru = $nama_gambar . '_' . time() . '.' . $ext;

                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048;
                $config['upload_path'] = './asset/img/sejarah/';
                $config['file_name'] = $nama_gambar_baru;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('gambar_sejarah')) {
                    $old_image = $data['sejarah']['gambar_sejarah'];
                    if ($old_image && file_exists(FCPATH . 'asset/img/sejarah/' . $old_image)) {
                        unlink(FCPATH . 'asset/img/sejarah/' . $old_image);
                    }
                    $new_img = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah gambar: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_sejarah/edit/' . $id);
                }
            } else {
                $new_img = $data['sejarah']['gambar_sejarah'];
            }

            $data_update = [
                'tahun' => $this->input->post('tahun', true),
                'kategori' => $this->input->post('kategori', true),
                'isi' => $this->input->post('isi', true),
                'gambar_sejarah' => $new_img
            ];

            $this->sejarah->updateSejarah($id, $data_update);
            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data berhasil diperbarui!</div>');
            redirect('d_sejarah');
        }
    }
}