<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class D_Kategorial extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->model('Kategorial_model', 'kategorial');

        if (!$this->session->userdata('email')) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Silakan login terlebih dahulu!</div>');
            redirect('auth');
        }
    }

    public function index()
    {
        // Cek apakah user sudah login
        if (!$this->session->userdata('email')) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Silakan login terlebih dahulu!</div>');
            redirect('auth');
        }
    
        // Ambil data user
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    
        // Cek apakah user ada
        if (!$data['user']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengguna tidak ditemukan! Silakan login ulang.</div>');
            $this->session->unset_userdata('email');
            redirect('auth');
        }
    
        // Cek apakah view utama ada
        $view_path = APPPATH . 'views/d_kategorial/index.php';
        if (!file_exists($view_path)) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Halaman kategorial tidak ditemukan!</div>');
            redirect('home'); // Redirect ke home jika view tidak ada
        }
    
        // Siapkan data
        $data['title'] = 'Kategorial';
        $search = $this->input->get('search', true);
        $status = $this->input->get('status', true);
    
        // Load model (pastikan model sudah ada)
        $this->load->model('Kategorial_model', 'kategorial');
    
        // Ambil data kategorial berdasarkan role
        if ($data['user']['role_id'] == 1) {
            $data['kategorial'] = $this->kategorial->getKategorial($search, $status);
        } else {
            $data['kategorial'] = $this->kategorial->getKategorialByUser($data['user']['id'], $search, $status);
        }
    
        // Set rules validasi
        $this->form_validation->set_rules('judul', 'Judul', 'required|trim');
        $this->form_validation->set_rules('keterangan', 'Keterangan', 'required|trim|max_length[50]');
    
        // Proses request
        if ($this->input->post()) {
            if ($this->form_validation->run() == false) {
                // Jika validasi gagal
                $this->load->view('template/user_header', $data);
                $this->load->view('template/sidebar', $data);
                $this->load->view('template/topbar', $data);
                $this->load->view('d_kategorial/index', $data);
                $this->load->view('template/user_footer');
            } else {
                // Jika validasi sukses
                $upload_image = $_FILES['logo']['name'];
                $new_img = null;
    
                if ($upload_image) {
                    $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                    $nama_foto = basename($upload_image, '.' . $ext);
                    $nama_foto_baru = $nama_foto . '_' . time() . '.' . $ext;
    
                    $config['upload_path'] = './asset/img/kategorial/';
                    $config['allowed_types'] = 'gif|jpg|png';
                    $config['max_size'] = 12048; // 12MB
                    $config['file_name'] = $nama_foto_baru;
                    $config['overwrite'] = true;
    
                    $this->load->library('upload', $config);
    
                    if ($this->upload->do_upload('logo')) {
                        $new_img = $this->upload->data('file_name');
                    } else {
                        $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah logo: ' . $this->upload->display_errors() . '</div>');
                        redirect('d_kategorial');
                    }
                }
    
                $data_insert = [
                    'judul' => $this->input->post('judul', true),
                    'keterangan' => $this->input->post('keterangan', true),
                    'deskripsi' => $this->input->post('deskripsi', true),
                    'logo' => $new_img,
                    'role' => 0,
                    'user_id' => $data['user']['id']
                ];
    
                if ($this->db->insert('kategorial_db', $data_insert)) {
                    $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data kategorial berhasil ditambahkan!</div>');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal menyimpan data!</div>');
                }
                redirect('d_kategorial');
            }
        } else {
            // Tampilan awal (GET request)
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_kategorial/index', $data);
            $this->load->view('template/user_footer');
        }
    }

    public function publish($id) {
        $user = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        if ($user['role_id'] != 1) {
            redirect('d_kategorial');
        }

        $this->db->set('role', 1);
        $this->db->where('id', $id);
        $this->db->update('kategorial_db');

        $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data kategorial berhasil dipublikasikan!</div>');
        redirect('d_kategorial');
    }

    public function delete($id) {
        $kategorial = $this->db->get_where('kategorial_db', ['id' => $id])->row_array();

        if ($kategorial) {
            if ($kategorial['logo'] && file_exists(FCPATH . 'asset/img/kategorial/' . $kategorial['logo'])) {
                unlink(FCPATH . 'asset/img/kategorial/' . $kategorial['logo']);
            }

            $this->db->where('id', $id);
            $this->db->delete('kategorial_db');

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data kategorial berhasil dihapus!</div>');
        } else {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Data tidak ditemukan!</div>');
        }
        redirect('d_kategorial');
    }

    public function edit($id) {
        $data['title'] = 'Edit Kategorial';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['kategorial'] = $this->db->get_where('kategorial_db', ['id' => $id])->row_array();

        if (!$data['kategorial']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Data tidak ditemukan!</div>');
            redirect('d_kategorial');
        }

        $this->form_validation->set_rules('judul', 'Judul', 'required');
        $this->form_validation->set_rules('keterangan', 'Keterangan', 'required|max_length[50]');

        if ($this->form_validation->run() == false) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_kategorial/edit', $data);
            $this->load->view('template/user_footer');
        } else {
            $upload_image = $_FILES['logo']['name'];
            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_foto = basename($upload_image, '.' . $ext);
                $nama_foto_baru = $nama_foto . '_' . time() . '.' . $ext;

                $config['upload_path'] = './asset/img/kategorial/';
                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048;
                $config['file_name'] = $nama_foto_baru;
                $config['overwrite'] = TRUE;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('logo')) {
                    $old_image = $data['kategorial']['logo'];
                    if ($old_image && file_exists(FCPATH . 'asset/img/kategorial/' . $old_image)) {
                        unlink(FCPATH . 'asset/img/kategorial/' . $old_image);
                    }
                    $new_img = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah logo: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_kategorial/edit/' . $id);
                }
            } else {
                $new_img = $data['kategorial']['logo'];
            }

            $data_update = [
                'judul' => $this->input->post('judul'),
                'keterangan' => $this->input->post('keterangan'),
                'deskripsi' => $this->input->post('deskripsi'),
                'logo' => $new_img,
                'role' => 0
            ];

            $this->db->where('id', $id);
            if ($this->db->update('kategorial_db', $data_update)) {
                $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data kategorial berhasil diperbarui!</div>');
            } else {
                $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal memperbarui data!</div>');
            }
            redirect('d_kategorial');
        }
    }
}