<?php

class Admin extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        is_logged_in(); 
    }
    public function index()
{
    // Cek apakah user sudah login
    if (!$this->session->userdata('email')) {
        $this->session->set_flashdata('error', 'Silakan login terlebih dahulu');
        redirect('login'); // Redirect ke halaman login jika belum login
    }

    // Ambil data user dari database
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

    // Cek apakah data user ada
    if (!$data['user']) {
        $this->session->set_flashdata('error', 'Data pengguna tidak ditemukan');
        $this->session->unset_userdata('email'); // Hapus session
        redirect('login'); // Redirect ke login jika user tidak ditemukan
    }

    // Cek apakah view utama ada
    $view_path = APPPATH . 'views/admin/index.php';
    if (!file_exists($view_path)) {
        $this->session->set_flashdata('error', 'Halaman dashboard tidak ditemukan');
        redirect('home'); // Redirect ke home jika view tidak ada
    }

    // Siapkan data untuk view
    $data['title'] = 'Dashboard';

    // Load semua view
    $this->load->view('template/user_header', $data);
    $this->load->view('template/sidebar', $data);
    $this->load->view('template/topbar', $data);
    $this->load->view('admin/index', $data);
    $this->load->view('template/user_footer');
}


    public function role()
    {
        $data['title'] = 'Role';
        $data['user'] = $this->db->get_where('user', ['email'=> $this->session->userdata('email')])->row_array();

        $data['role'] = $this->db->get('user_role')->result_array();

        $this->load->view('template/user_header',$data);
        $this->load->view('template/sidebar',$data);
        $this->load->view('template/topbar',$data);
        $this->load->view('admin/role',$data);
        $this->load->view('template/user_footer');
    }

    public function roleAccess($role_id)
    {
        $data['title'] = 'Role Access';
        $data['user'] = $this->db->get_where('user', ['email'=> $this->session->userdata('email')])->row_array();
    
        $data['role'] = $this->db->get_where('user_role', ['id' => $role_id])->row_array();

        $this->db->where('id !='. 1);
        $data['menu'] = $this->db->get('user_menu')->result_array();
    
        $this->load->view('template/user_header',$data);
        $this->load->view('template/sidebar',$data);
        $this->load->view('template/topbar',$data);
        $this->load->view('admin/role-access',$data);
        $this->load->view('template/user_footer');
    }

    public function changeAccess()
    {
        $menu_id = $this->input->post('menuId');
        $role_id = $this->input->post('roleId');

        $data = [
            'role_id'=> $role_id,
            'menu_id'=> $menu_id
        ];

        $result = $this->db->get_where('user_access_menu', $data);

        if($result->num_rows() < 1) {
            $this->db->insert('user_access_menu', $data);
        } else {
            $this->db->delete('user_access_menu', $data);
        }

        $this->session->set_flashdata('message5', '<div class="alert alert-success" role="alert">Access Changed!</div>');
        
    }
}