<!-- Sesi Baru: Artikel -->
<section class="artikeldb">
    <div class="container artikel-content">
        <h2 class="section-title2">Artikel</h2>
        <p class="title-kecil2">Paroki Santa Maria Blitar</p>
        <hr class="section-divider2" />
        <!-- Form Pencarian -->
        <div class="search-container">
            <form action="<?= base_url('web/artikel') ?>" method="get">
                <div class="input-group">
                    <input type="text" name="search" class="form-control" placeholder="Cari judul, kategori, atau isi..." 
                           value="<?= htmlspecialchars($search ?? '') ?>">
                    <div class="input-group-append">
                        <button type="submit" class="btn btn-search">Cari</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</section>

<section class="artikelisi">
    <div class="container artikel-content">
        <div class="artikel-container">
            <?php if (!empty($artikel)): ?>
                <?php foreach ($artikel as $item): ?>
                    <div class="artikel-item" data-url="<?= base_url('web/detail_artikel/' . $item['id']) ?>">
                        <div class="artikel-image">
                            <img src="<?= base_url('asset/img/artikel/') . $item['linkg1'] ?>" 
                                 alt="<?= htmlspecialchars($item['judul']) ?>" />
                        </div>
                        <div class="artikel-content">
                            <h3 class="artikel-title"><?= htmlspecialchars($item['judul']) ?></h3>
                            <p class="artikel-date">Diperbarui: <?= date('d F Y', strtotime($item['tanggal'])) ?></p>
                            <p class="artikel-excerpt">
                                <?= substr($item['isi'], 0, 100) . (strlen($item['isi']) > 100 ? '...' : '') ?>
                            </p>
                            <a href="<?= base_url('web/detail_artikel/' . $item['id']) ?>" class="artikel-link">Baca Selengkapnya >></a>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p>Tidak ada artikel tersedia saat ini.</p>
            <?php endif; ?>
        </div>
        <div class="pagination">
            <?= $pagination; ?>
            <?php if ($current_page < $total_pages): ?>
                <a href="<?= base_url('web/artikel?page=' . ($current_page + 1) . ($search ? '&search=' . urlencode($search) : '')) ?>" class="btn-next">Next</a>
            <?php endif; ?>
        </div>
    </div>
</section>

<style>
/* Artikel Database Section */
.artikeldb {
    position: relative; /* Diperlukan untuk overlay ::before */
    background-image: url("<?php echo base_url('asset/website/img/bg6.jpg'); ?>"); /* Path dengan base_url */
    background-size: cover;
    background-position: center;
    background-attachment: fixed; /* Background tetap saat scroll */
    color: #f4f1e8; /* Warna teks krem muda untuk kontras */
    padding: 5rem 0; /* Padding vertikal besar */
}

/* Overlay untuk transparansi 70% dengan warna coklat */
.artikeldb::before {
    content: "";
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(155, 72, 25, 0.8); /* Warna coklat #9b4819 dengan transparansi 70% */
    z-index: 1;
}

/* Artikel Isi Section */
.artikelisi {
    background: #f4f1e8; /* Background krem muda */
    color: #9b4819; /* Warna teks coklat untuk kontras */
    padding: 2rem 0; /* Padding sesuai artikel-container */
}

/* Pastikan konten di atas overlay (hanya untuk artikeldb) */
.artikeldb .artikel-content {
    position: relative;
    z-index: 2; /* Konten di atas overlay */
}

/* Container */
.container {
    max-width: 1000px; /* Lebar maksimum untuk daftar artikel */
    margin: 0 auto;
    padding: 0 15px;
}

/* Header Section (Digunakan di Daftar dan Detail Artikel) */
.section-title2 {
    font-size: 36px;
    font-weight: bold;
    text-align: center;
    color: #f4f1e8; /* Krem muda untuk artikeldb */
    margin-bottom: 10px;
    margin-top: 60px;
}

.artikelisi .section-title2 {
    color: #9b4819; /* Coklat untuk artikelisi */
}

.title-kecil2 {
    font-size: 24px;
    color: #f4f1e8; /* Krem muda untuk artikeldb */
    text-align: center;
    margin-bottom: 20px;
}

.artikelisi .title-kecil2 {
    color: #666; /* Abu-abu untuk artikelisi */
}

.section-divider2 {
    width: 30rem;
    height: 1px;
    background: #f4f1e8; /* Krem muda untuk artikeldb */
    border: none;
    margin: 1rem auto 30px;
}

.artikelisi .section-divider2 {
    background: #9b4819; /* Coklat untuk artikelisi */
}

.section-title-link,
.title-kecil-link {
    text-decoration: none;
    color: inherit;
    display: block;
}

.section-title-link:hover .section-title2,
.title-kecil-link:hover .title-kecil2 {
    color: #d9c2a6; /* Warna lebih terang untuk artikeldb */
}

.artikelisi .section-title-link:hover .section-title2,
.artikelisi .title-kecil-link:hover .title-kecil2 {
    color: #7a3814; /* Warna lebih gelap untuk artikelisi */
}

/* Search Container (Daftar Artikel) */
.search-container {
    margin-bottom: 30px;
}

.search-container .input-group {
    display: flex;
    max-width: 400px;
    margin: 0 auto;
}

.search-container .form-control {
    background-color: #fff; /* Latar putih untuk kontras */
    border: 1px solid #ccc;
    border-right: none;
    border-radius: 5px 0 0 5px;
    padding: 12px;
    flex-grow: 1;
    font-size: 14px;
}

.search-container .btn-search {
    background-color: #9b4819;
    border: 1px solid #9b4819;
    color: white;
    border-radius: 0 5px 5px 0;
    padding: 12px 20px;
    white-space: nowrap;
    font-size: 14px;
    transition: background-color 0.3s ease;
}

.search-container .btn-search:hover {
    background-color: #7a3814;
    border-color: #7a3814;
}

/* Artikel Container (Daftar Artikel) */
.artikel-container {
    padding: 2rem 0;
}

.artikel-item {
    display: flex;
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    margin-bottom: 20px;
    overflow: hidden;
    cursor: pointer; /* Menunjukkan elemen dapat diklik */
    transition: box-shadow 0.3s ease, transform 0.2s ease; /* Efek transisi */
}

.artikel-item:hover {
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15); /* Bayangan lebih kuat saat hover */
    transform: translateY(-2px); /* Sedikit naik */
}

.artikel-image {
    flex: 1;
    max-width: 150px;
    max-height: 120px;
}

.artikel-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: 10px 0 0 10px; /* Sudut membulat hanya di sisi kiri */
}

.artikel-content {
    flex: 7;
    padding: 15px;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
}

.artikel-title {
    font-size: 20px;
    font-weight: bold;
    color: #9b4819;
    margin-bottom: 5px;
}

.artikel-date {
    font-size: 12px;
    color: #666;
    margin-bottom: 10px;
}

.artikel-excerpt {
    font-size: 14px;
    color: #333;
    margin: 0;
    max-width: 100ch;
    overflow: hidden;
    text-overflow: ellipsis;
}

.artikel-link {
    font-size: 12px;
    color: #9b4819;
    text-decoration: none;
    align-self: flex-end;
    transition: color 0.3s ease;
}

.artikel-link:hover {
    color: #7a3814;
    text-decoration: underline;
}

/* Pagination (Daftar Artikel) */
.pagination {
    text-align: center;
    margin: 20px 0;
    display: flex;
    justify-content: center;
    align-items: center;
}

.pagination a,
.pagination span {
    margin: 0 5px;
    padding: 8px 12px;
    text-decoration: none;
    color: #9b4819; /* Coklat untuk artikelisi */
    font-size: 14px;
    border-radius: 5px;
    transition: background-color 0.3s ease;
}

.pagination .current {
    background-color: #9b4819;
    color: white;
}

.pagination a:hover {
    background-color: #f0f0f0; /* Abu-abu muda saat hover */
}

/* Detail Artikel */
.artikel.py-53 {
    padding-top: 3rem;
    padding-bottom: 3rem;
}

.container3 {
    max-width: 800px; /* Membatasi lebar container */
    margin: 0 auto; /* Memusatkan container */
    padding: 0 15px; /* Memberikan padding samping */
}

.section-title3 {
    font-size: 28px;
    font-weight: bold;
    text-align: center;
    margin-bottom: 10px;
}

.title-kecil3 {
    font-size: 16px;
    color: #666;
    text-align: center;
    margin-bottom: 20px;
}

.section-divider3 {
    width: 50px;
    height: 3px;
    background-color: #7a3814;
    margin: 0 auto 30px;
    border: none;
}

.detail-artikel-container {
    margin: 20px 0;
    text-align: center; /* Memusatkan konten di dalamnya */
}

.detail-artikel-title {
    font-size: 32px; /* Membesarkan ukuran judul */
    font-weight: bold;
    margin-bottom: 15px;
    text-align: center; /* Memusatkan judul */
}

.detail-artikel-date {
    color: #666;
    font-size: 14px;
    margin-bottom: 20px;
    text-align: center; /* Memusatkan tanggal */
}

.detail-artikel-image {
    display: flex;
    justify-content: center; /* Memusatkan gambar */
    margin-bottom: 20px;
}

.detail-artikel-image img {
    max-width: 100%;
    height: auto;
    border-radius: 8px; /* Opsional: Memberikan sudut membulat pada gambar */
}

.detail-artikel-content {
    line-height: 1.6;
    text-align: justify; /* Konten artikel rata kiri-kanan */
    margin-bottom: 20px;
}

.btn-back {
    display: inline-block;
    padding: 10px 20px;
    background-color: #7a3814;
    color: white;
    text-decoration: none;
    border-radius: 5px;
    transition: background-color 0.3s ease; /* Efek transisi saat hover */
}

.btn-back:hover {
    background-color: #5e2a0f; /* Warna lebih gelap saat hover */
}

/* Media Queries untuk Responsivitas */
@media (max-width: 1024px) {
    .container {
        max-width: 800px;
    }
    .artikel-title {
        font-size: 18px;
    }
    .artikel-excerpt {
        font-size: 13px;
    }
    .detail-artikel-title {
        font-size: 32px;
    }
    .section-title2 {
        font-size: 26px;
    }
}

@media (max-width: 790px) {
    .artikeldb {
        padding: 40px 0;
    }
    .artikelisi {
        padding: 40px 0;
    }
}

@media (max-width: 480px) {
    .artikeldb {
        padding: 30px 0;
        background-attachment: scroll; /* Fallback untuk mobile */
    }
    .artikelisi {
        padding: 30px 0;
    }
    .section-title2 {
        font-size: 24px;
    }
    .title-kecil2 {
        font-size: 18px;
    }
    .section-divider2 {
        width: 20rem;
    }
    .artikel-item {
        flex-direction: column; /* Gambar di atas, konten di bawah */
    }
    .artikel-image {
        max-width: none;
        max-height: 50%;
        height: 20px; /* Tinggi tetap untuk gambar */
    }
    .artikel-image img {
        width: 100%;
        height: 8rem;
        object-fit: cover;
        border-radius: 10px 10px 0 0; /* Sudut membulat atas */
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.08);
    }
    .artikel-content {
        padding: 10px;
    }
    .artikel-date {
        font-size: 11px;
    }
    .artikel-excerpt {
        font-size: 10px;
    }
    .artikel-link {
        font-size: 11px;
    }
}
</style>