<!-- Begin Page Content -->
<div class="container-fluid">

    <!-- Page Heading -->
    <h1 class="h3 mb-4 text-gray-800"><?= $title; ?></h1>

    <div class="row">
        <div class="col-lg">
            <!-- Tombol Add New Artikel dan Add Kategori -->
            <a href="" class="btn btn-primary mb-3" data-toggle="modal" data-target="#newArtikelModal">Add New Artikel</a>
            <?php if ($user['role_id'] == 1) : ?>
                <a href="" class="btn btn-success mb-3" data-toggle="modal" data-target="#newKategoriModal">Add Kategori</a>
            <?php endif; ?>

            <!-- Form Pencarian dan Filter Status -->
            <form method="get" action="<?= base_url('d_pengumuman'); ?>" class="mb-3">
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="Cari pengumuman..." value="<?= isset($_GET['search']) ? $_GET['search'] : ''; ?>">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">Search</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select name="status" class="form-control" onchange="this.form.submit()">
                            <option value="all" <?= isset($_GET['status']) && $_GET['status'] == 'all' ? 'selected' : ''; ?>>All</option>
                            <option value="pending" <?= isset($_GET['status']) && $_GET['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                            <option value="public" <?= isset($_GET['status']) && $_GET['status'] == 'public' ? 'selected' : ''; ?>>Public</option>
                        </select>
                    </div>
                </div>
            </form>

            <table class="table table-hover">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Judul</th>
                        <th scope="col">Tanggal Kegiatan</th>
                        <th scope="col">Jam Kegiatan</th>
                        <th scope="col">Tempat Kegiatan</th>
                        <th scope="col">Panitia</th>
                        <th scope="col">Status</th>
                        <th scope="col">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php foreach ($pengumuman as $p) : ?>
                    <tr>
                        <th scope="row" style="cursor: pointer;" data-toggle="modal" data-target="#detailPengumumanModal<?= $p['id']; ?>"><?= $i; ?></th>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailPengumumanModal<?= $p['id']; ?>">
                            <?php
                            if (strlen($p['judul']) > 20) {
                                echo substr($p['judul'], 0, 50) . "...";
                            } else {
                                echo $p['judul'];
                            }
                            ?>
                        </td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailPengumumanModal<?= $p['id']; ?>"><?= $p['tanggal_kegiatan']; ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailPengumumanModal<?= $p['id']; ?>"><?= $p['jam_kegiatan']; ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailPengumumanModal<?= $p['id']; ?>"><?= $p['tempat_kegiatan']; ?></td>
                        <td style="cursor: pointer;" data-toggle="modal" data-target="#detailPengumumanModal<?= $p['id']; ?>"><?= $p['panitia']; ?></td>
                        <td>
                            <?php if ($user['role_id'] == 1) : ?>
                                <?php if ($p['role'] == 0) : ?>
                                    <a href="<?= base_url('d_pengumuman/publish/') . $p['id']; ?>" class="badge badge-warning" onclick="return confirm('Apakah Anda yakin ingin mempublikasikan pengumuman ini?')">Pending</a>
                                <?php elseif ($p['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php else : ?>
                                <?php if ($p['role'] == 0) : ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php elseif ($p['role'] == 1) : ?>
                                    <span class="badge badge-success">Public</span>
                                <?php endif; ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?= base_url('d_pengumuman/edit/') . $p['id']; ?>" class="badge badge-success">Edit</a>
                            <a href="<?= base_url('d_pengumuman/delete/') . $p['id']; ?>" class="badge badge-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus pengumuman ini?')">Delete</a>
                        </td>
                    </tr>

                    <!-- Modal Detail Pengumuman -->
                    <div class="modal fade" id="detailPengumumanModal<?= $p['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="detailPengumumanModalLabel<?= $p['id']; ?>" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <!-- Judul besar -->
                                    <h2 class="modal-title w-100" id="detailPengumumanModalLabel<?= $p['id']; ?>"><?= $p['judul']; ?></h2>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <!-- Tanggal Kegiatan | Jam Kegiatan | Kategori | Panitia -->
                                    <p class="text-muted small mb-2">
                                        <?= $p['tanggal_kegiatan']; ?> | <?= $p['jam_kegiatan']; ?> | <?= $p['kategori']; ?> | <?= $p['panitia']; ?>
                                    </p>
                                    <!-- Tempat Kegiatan - Reservasi -->
                                    <p class="text-muted small mb-3">
                                        <?= $p['tempat_kegiatan']; ?> - <?= $p['reservasi_fasilitas']; ?>
                                    </p>
                                    <!-- Gambar -->
                                    <?php if (!empty($p['upload_gambar'])) : ?>
                                        <img src="<?= base_url('asset/img/pengumuman/') . $p['upload_gambar']; ?>" class="img-fluid mb-3" alt="<?= $p['judul']; ?>">
                                    <?php endif; ?>
                                    <!-- Deskripsi -->
                                    <div class="pengumuman-isi">
                                        <?= nl2br($p['deskripsi']); ?>
                                    </div>
                                    <!-- Kontak CS -->
                                    <p class="mt-3">Kontak: <?= $p['kontak_cs']; ?></p>
                                    <!-- Tanggal Terbit di pojok kanan bawah -->
                                    <p class="text-muted small text-right mt-3"><?= date('d F Y H:i', strtotime($p['tanggal_terbit'])); ?></p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal Tambah Pengumuman -->
    <div class="modal fade" id="newArtikelModal" tabindex="-1" role="dialog" aria-labelledby="newArtikelModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newArtikelModalLabel">Add New Pengumuman</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form action="<?= base_url('d_pengumuman'); ?>" method="post" enctype="multipart/form-data">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="judul">Judul <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="judul" name="judul" placeholder="Masukkan judul pengumuman" required>
                        </div>
                        <div class="form-group">
                            <label for="tanggal_kegiatan">Tanggal Kegiatan <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="tanggal_kegiatan" name="tanggal_kegiatan" required>
                        </div>
                        <div class="form-group">
                            <label for="jam_kegiatan">Jam Kegiatan <span class="text-danger">*</span></label>
                            <input type="time" class="form-control" id="jam_kegiatan" name="jam_kegiatan" required>
                        </div>
                        <div class="form-group">
                            <label for="tempat_kegiatan">Tempat Kegiatan <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="tempat_kegiatan" name="tempat_kegiatan" placeholder="Masukkan tempat kegiatan" required>
                        </div>
                        <div class="form-group">
                            <label for="reservasi_fasilitas">Reservasi Fasilitas</label>
                            <input type="text" class="form-control" id="reservasi_fasilitas" name="reservasi_fasilitas" placeholder="Masukkan reservasi fasilitas">
                        </div>
                        <div class="form-group">
                            <label for="panitia">Panitia <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="panitia" name="panitia" placeholder="Masukkan nama panitia" required>
                        </div>
                        <div class="form-group">
                            <label for="kontak_cs">Kontak CS <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="kontak_cs" name="kontak_cs" placeholder="Masukkan kontak CS" required>
                        </div>
                        <div class="form-group">
                            <label for="kategori">Kategori <span class="text-danger">*</span></label>
                            <select name="kategori" id="kategori" class="form-control" required>
                                <?php foreach ($kategori as $kat) : ?>
                                    <option value="<?= $kat['nama']; ?>"><?= $kat['nama']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="deskripsi">Deskripsi <span class="text-danger">*</span></label>
                            <textarea class="form-control" id="deskripsi" name="deskripsi" rows="5" required></textarea>
                        </div>
                        <div class="custom-file">
                            <label for="gambar">Upload Gambar</label>
                            <input type="file" class="custom-file-input" id="gambar" name="gambar">
                            <label class="custom-file-label" for="gambar">Choose file</label>
                            <p>maksimal size 12MB </p>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Tambah Kategori -->
    <?php if ($user['role_id'] == 1) : ?>
    <div class="modal fade" id="newKategoriModal" tabindex="-1" role="dialog" aria-labelledby="newKategoriModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newKategoriModalLabel">Tambah Kategori Baru</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form action="<?= base_url('d_pengumuman/add_kategori'); ?>" method="post">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="kategori">Kategori</label>
                            <input type="text" class="form-control" id="kategori" name="kategori" placeholder="Masukkan nama kategori" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>
<!-- /.container-fluid -->

<script>
function readURL(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function(e) {
            $('.custom-file-label').html(input.files[0].name);
        }
        reader.readAsDataURL(input.files[0]);
    }
}
</script>