

    <!-- Begin Page Content -->
    <div class="container-fluid">

<!-- Page Heading -->
<h1 class="h3 mb-4 text-gray-800"><?= $title;?></h1>
<div class="row">
        <div class="col-lg">
            <!-- Tombol Add New Doa dan Add Kategori -->
            <a href="" class="btn btn-primary mb-3" data-toggle="modal" data-target="#newDoaModal">Add New Doa</a>
            <a href="" class="btn btn-success mb-3" data-toggle="modal" data-target="#newKategoriDoaModal">Add Kategori</a>

            <!-- Form Pencarian dan Filter Status -->
            <form method="get" action="<?= base_url('d_kumpulandoa'); ?>" class="mb-3">
                <div class="row">
                    <div class="col-md-6">
                        <div class="input-group">
                            <input type="text" name="search" class="form-control" placeholder="Cari doa..." value="<?= isset($_GET['search']) ? $_GET['search'] : ''; ?>">
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">Search</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <select name="status" class="form-control" onchange="this.form.submit()">
                            <option value="all" <?= isset($_GET['status']) && $_GET['status'] == 'all' ? 'selected' : ''; ?>>All</option>
                            <option value="pending" <?= isset($_GET['status']) && $_GET['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                            <option value="public" <?= isset($_GET['status']) && $_GET['status'] == 'public' ? 'selected' : ''; ?>>Public</option>
                        </select>
                    </div>
                </div>
            </form>

            <table class="table table-hover">
    <thead>
        <tr>
            <th scope="col">#</th>
            <th scope="col">Judul</th>
            <th scope="col">Doa</th>
            <th scope="col">Referensi</th>
            <th scope="col">Kategori</th>
            <th scope="col">Status</th>
            <th scope="col">Action</th>
        </tr>
    </thead>
    <tbody>
        <?php $i = 1; ?>
        <?php foreach ($doa as $d) : ?>
        <tr>
            <!-- Area klik untuk modal dari Nomor hingga Referensi -->
            <th scope="row" style="cursor: pointer;" data-toggle="modal" data-target="#detailDoaModal<?= $d['id']; ?>"><?= $i; ?></th>
            <td style="cursor: pointer;" data-toggle="modal" data-target="#detailDoaModal<?= $d['id']; ?>">
                <?php
                if (strlen($d['judul']) > 20) {
                    echo substr($d['judul'], 0, 20) . "...";
                } else {
                    echo $d['judul'];
                }
                ?>
            </td>
            <td style="cursor: pointer;" data-toggle="modal" data-target="#detailDoaModal<?= $d['id']; ?>">
                <?php
                if (strlen($d['doa']) > 20) {
                    echo nl2br(substr($d['doa'], 0, 30)) . "...";
                } else {
                    echo nl2br($d['doa']);
                }
                ?>
            </td>
            <td style="cursor: pointer;" data-toggle="modal" data-target="#detailDoaModal<?= $d['id']; ?>"><?= $d['referensi']; ?></td>
            <td style="cursor: pointer;" data-toggle="modal" data-target="#detailDoaModal<?= $d['id']; ?>"><?= $d['kategori_doa']; ?></td>
            <!-- Kolom Status dan Action tidak memicu modal -->
            <td>
                <?php if ($user['role_id'] == 1) : ?>
                    <?php if ($d['role'] == 0) : ?>
                        <a href="<?= base_url('d_kumpulandoa/publish/') . $d['id']; ?>" class="badge badge-warning" onclick="return confirm('Apakah Anda yakin ingin mempublikasikan doa ini?')">Pending</a>
                    <?php elseif ($d['role'] == 1) : ?>
                        <span class="badge badge-success">Public</span>
                    <?php endif; ?>
                <?php else : ?>
                    <?php if ($d['role'] == 0) : ?>
                        <span class="badge badge-warning">Pending</span>
                    <?php elseif ($d['role'] == 1) : ?>
                        <span class="badge badge-success">Public</span>
                    <?php endif; ?>
                <?php endif; ?>
            </td>
            <td>
                <a href="<?= base_url('d_kumpulandoa/editdoa/') . $d['id']; ?>" class="badge badge-success">Edit</a>
                <a href="<?= base_url('d_kumpulandoa/delete/') . $d['id']; ?>" class="badge badge-danger" onclick="return confirm('Apakah Anda yakin ingin menghapus doa ini?')">Delete</a>
            </td>
        </tr>

        <!-- Modal Detail Doa -->
        <div class="modal fade" id="detailDoaModal<?= $d['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="detailDoaModalLabel<?= $d['id']; ?>" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <!-- Judul besar -->
                        <h2 class="modal-title w-100" id="detailDoaModalLabel<?= $d['id']; ?>"><?= $d['judul']; ?></h2>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <!-- Kategori | Tanggal | Penulis kecil di bawah judul -->
                        <p class="text-muted small mb-3">
                            <?= $d['kategori_doa']; ?> | 
                            <?php 
                                echo isset($d['tanggal']) ? date('d F Y H:i', strtotime($d['tanggal'])) : 'Tanggal tidak tersedia'; 
                            ?> | 
                            <?php 
                                echo isset($d['penulis']) ? $d['penulis'] : $user['name']; 
                            ?>
                        </p>

                        <!-- Isi doa -->
                        <div class="doa-isi">
                            <?= nl2br($d['doa']); ?>
                        </div>

                        <!-- Referensi (jika ada) -->
                        <?php if (!empty($d['referensi'])) : ?>
                            <small class="text-muted d-block mt-3">Referensi: <?= $d['referensi']; ?></small>
                        <?php endif; ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
        <?php $i++; ?>
        <?php endforeach; ?>
    </tbody>
</table>
        </div>
    </div>

    <!-- Modal Tambah Doa -->
    <div class="modal fade" id="newDoaModal" tabindex="-1" role="dialog" aria-labelledby="newDoaModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newDoaModalLabel">Tambah Doa Baru</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form action="<?= base_url('d_kumpulandoa'); ?>" method="post">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="judul">Judul</label>
                            <input type="text" class="form-control" id="judul" name="judul" placeholder="Masukkan judul doa" required>
                        </div>
                        <div class="form-group">
                            <label for="doa">Doa</label>
                            <textarea class="form-control" id="doa" name="doa" placeholder="Masukkan isi doa" required></textarea>
                        </div>
                        <div class="form-group">
                            <label for="referensi">Referensi</label>
                            <input type="text" class="form-control" id="referensi" name="referensi" placeholder="Masukkan referensi (opsional)">
                        </div>
                        <div class="form-group">
                            <label for="kategori_doa">Kategori Doa</label>
                            <select class="form-control" id="kategori_doa" name="kategori_doa" required>
                                <?php foreach ($kategori_doa as $kat) : ?>
                                    <option value="<?= $kat['nama']; ?>"><?= $kat['nama']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Tambah Kategori Doa -->
    <div class="modal fade" id="newKategoriDoaModal" tabindex="-1" role="dialog" aria-labelledby="newKategoriDoaModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="newKategoriDoaModalLabel">Tambah Kategori Doa Baru</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <form action="<?= base_url('d_kumpulandoa/add_kategori'); ?>" method="post">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="kategori_doa">Kategori Doa</label>
                            <input type="text" class="form-control" id="kategori_doa" name="kategori_doa" placeholder="Masukkan nama kategori" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>