<?php
class Sejarah_model extends CI_Model {
    public function getSejarah($search = null, $status = null) {
        $this->db->order_by('id', 'DESC'); // Urutkan berdasarkan tanggal_penulisan terbaru
        if ($search) {
            $this->db->like('tahun', $search);
            $this->db->or_like('kategori', $search);
            $this->db->or_like('isi', $search);
        }
        if ($status) $this->db->where('role', $status === 'pending' ? 0 : 1);
        return $this->db->get('sejarah_db')->result_array();
    }

    public function getSejarahByUser($id_user, $search = null, $status = null) {
        $this->db->order_by('id', 'DESC'); // Urutkan berdasarkan tanggal_penulisan terbaru
        if ($search) {
            $this->db->like('tahun', $search);
            $this->db->or_like('kategori', $search);
            $this->db->or_like('isi', $search);
        }
        if ($status) $this->db->where('role', $status === 'pending' ? 0 : 1);
        return $this->db->get('sejarah_db')->result_array();
    }

    public function getSejarahById($id) {
        return $this->db->get_where('sejarah_db', ['id' => $id])->row_array();
    }

    public function updateSejarah($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('sejarah_db', $data);
    }

    public function getKategoriLingkungan() {
        $this->db->select("CONCAT(
            kategori, ' ',
            nama_pelindung,
            IF(kategori = 'Lingkungan', '', CONCAT(' ', lokasi))
        ) AS kategori_format", FALSE);
        $this->db->order_by('kategori', 'ASC');
        return $this->db->get('lingk_stasi')->result_array();
    }
}