<?php
class Lingkungan_model extends CI_Model {
    public function getLingkungan($search = null, $status = null) {
        $this->db->order_by('id', 'DESC');
        
        if ($search) {
            $this->db->group_start(); // Memulai grup untuk OR LIKE
            $this->db->like('kategori', $search);
            $this->db->or_like('nama_pelindung', $search);
            $this->db->or_like('lokasi', $search);
            $this->db->or_like('wilayah', $search);
            $this->db->or_like('nama_ketua', $search);
            $this->db->group_end(); // Mengakhiri grup
        }
        
        if ($status) {
            $this->db->where('role', $status === 'pending' ? 0 : 1);
        }
        
        return $this->db->get('lingk_stasi')->result_array();
    }

    public function getLingkunganByUser($id_user, $search = null, $status = null) {
        $this->db->where('id_ketua', $id_user);
        $this->db->order_by('id', 'DESC');
        if ($search) $this->db->like('nama_pelindung', $search);
        if ($status) $this->db->where('role', $status === 'pending' ? 0 : 1);
        return $this->db->get('lingk_stasi')->result_array();
    }

    public function getLingkunganById($id) {
        return $this->db->get_where('lingk_stasi', ['id' => $id])->row_array();
    }

    public function updateLingkungan($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('lingk_stasi', $data);
    }
}