<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Lagu_model extends CI_Model {

    public function getLagu($search = null, $status = null) {
        $this->db->order_by('id', 'DESC');

        if ($search) {
            $this->db->like('jenis_lagu', $search);
            $this->db->or_like('kategori_lagu', $search);
            $this->db->or_like('judul_lagu', $search);
            $this->db->or_like('deskripsi_lagu', $search);
        }

        if ($status == 'pending') {
            $this->db->where('role', 0);
        } elseif ($status == 'public') {
            $this->db->where('role', 1);
        }

        return $this->db->get('lagu_db')->result_array();
    }

    public function getLaguByUser($user_id, $search = null, $status = null) {
        $this->db->where('user_id', $user_id);
        $this->db->order_by('id', 'DESC');

        if ($search) {
            $this->db->like('jenis_lagu', $search);
            $this->db->or_like('kategori_lagu', $search);
            $this->db->or_like('judul_lagu', $search);
            $this->db->or_like('deskripsi_lagu', $search);
        }

        if ($status == 'pending') {
            $this->db->where('role', 0);
        } elseif ($status == 'public') {
            $this->db->where('role', 1);
        }

        return $this->db->get('lagu_db')->result_array();
    }
}