<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kategorial_model extends CI_Model {

    public function getKategorial($search = null, $status = null) {
        $this->db->order_by('id', 'DESC');

        if ($search) {
            $this->db->like('judul', $search);
            $this->db->or_like('keterangan', $search);
            $this->db->or_like('deskripsi', $search);
        }

        if ($status == 'pending') {
            $this->db->where('role', 0);
        } elseif ($status == 'public') {
            $this->db->where('role', 1);
        }

        return $this->db->get('kategorial_db')->result_array();
    }

    public function getKategorialByUser($user_id, $search = null, $status = null) {
        $this->db->where('user_id', $user_id);
        $this->db->order_by('id', 'DESC');

        if ($search) {
            $this->db->like('judul', $search);
            $this->db->or_like('keterangan', $search);
            $this->db->or_like('deskripsi', $search);
        }

        if ($status == 'pending') {
            $this->db->where('role', 0);
        } elseif ($status == 'public') {
            $this->db->where('role', 1);
        }

        return $this->db->get('kategorial_db')->result_array();
    }
}