<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class D_Panggilan extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->model('Panggilan_model', 'panggilan');

        if (!$this->session->userdata('email')) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Silakan login terlebih dahulu!</div>');
            redirect('auth');
        }
    }

    public function index() {
        $data['title'] = 'Daftar Panggilan';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

        if (!$data['user']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengguna tidak ditemukan! Silakan login ulang.</div>');
            redirect('auth');
        }

        $search = $this->input->get('search');
        $status = $this->input->get('status');

        if ($data['user']['role_id'] == 1) {
            $data['panggilan'] = $this->panggilan->getPanggilan($search, $status);
        } else {
            $data['panggilan'] = $this->panggilan->getPanggilanByUser($data['user']['id'], $search, $status);
        }

        $data['lingk_stasi'] = $this->db->get('lingk_stasi')->result_array();

        $this->form_validation->set_rules('nama_lengkap', 'Nama Lengkap', 'required');
        $this->form_validation->set_rules('tanggal_lahir', 'Tanggal Lahir');
        $this->form_validation->set_rules('domisili_tinggal', 'Domisili Tinggal', 'required');

        if ($this->form_validation->run() == false && !$this->input->post()) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_panggilan/index', $data);
            $this->load->view('template/user_footer');
        } else {
            $upload_image = $_FILES['link_foto']['name'];
            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_foto = basename($upload_image, '.' . $ext);
                $nama_foto_baru = $nama_foto . '_' . time() . '.' . $ext;

                $config['upload_path'] = './asset/img/panggilan/';
                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048;
                $config['file_name'] = $nama_foto_baru;
                $config['overwrite'] = TRUE;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('link_foto')) {
                    $new_img = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah foto: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_panggilan');
                }
            } else {
                $new_img = ''; // Default ke string kosong jika tidak ada upload
            }

            $data_insert = [
                'nama_lengkap' => $this->input->post('nama_lengkap'),
                'nama_panggilan' => $this->input->post('nama_panggilan') ?? '',
                'tempat_lahir' => $this->input->post('tempat_lahir') ?? '',
                'tanggal_lahir' => $this->input->post('tanggal_lahir') ?? '',
                'tempat_tahbisan' => $this->input->post('tempat_tahbisan') ?? '',
                'tanggal_tahbisan' => $this->input->post('tanggal_tahbisan') ?? '',
                'nama_ayah' => $this->input->post('nama_ayah') ?? '',
                'nama_ibu' => $this->input->post('nama_ibu') ?? '',
                'domisili_tinggal' => $this->input->post('domisili_tinggal'),
                'deskripsi' => $this->input->post('deskripsi') ?? '',
                'link_foto' => $new_img,
                'role' => 0,
                'user_id' => $data['user']['id'],
                'tanggal_update' => date('Y-m-d H:i:s'),
                'tarekat' => $this->input->post('tarekat') ?? '',
                'jabatan' => $this->input->post('jabatan') ?? '',
                'alamat_tinggal' => $this->input->post('alamat_tinggal') ?? ''
            ];

            if ($this->db->insert('panggilan_db', $data_insert)) {
                $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data panggilan berhasil ditambahkan!</div>');
            } else {
                $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal menyimpan data!</div>');
            }
            redirect('d_panggilan');
        }
    }

    public function publish($id) {
        $user = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        if ($user['role_id'] != 1) {
            redirect('d_panggilan');
        }

        $this->db->set('role', 1);
        $this->db->where('id', $id);
        $this->db->update('panggilan_db');

        $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data panggilan berhasil dipublikasikan!</div>');
        redirect('d_panggilan');
    }

    public function delete($id) {
        $panggilan = $this->db->get_where('panggilan_db', ['id' => $id])->row_array();

        if ($panggilan) {
            if ($panggilan['link_foto'] && file_exists(FCPATH . 'asset/img/panggilan/' . $panggilan['link_foto'])) {
                unlink(FCPATH . 'asset/img/panggilan/' . $panggilan['link_foto']);
            }

            $this->db->where('id', $id);
            $this->db->delete('panggilan_db');

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data panggilan berhasil dihapus!</div>');
        } else {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Data tidak ditemukan!</div>');
        }
        redirect('d_panggilan');
    }

    public function edit($id) {
        $data['title'] = 'Edit Panggilan';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['panggilan'] = $this->db->get_where('panggilan_db', ['id' => $id])->row_array();
        $data['lingk_stasi'] = $this->db->get('lingk_stasi')->result_array();

        if (!$data['panggilan']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Data tidak ditemukan!</div>');
            redirect('d_panggilan');
        }

        $this->form_validation->set_rules('nama_lengkap', 'Nama Lengkap', 'required');
        $this->form_validation->set_rules('tanggal_lahir', 'Tanggal Lahir');
        $this->form_validation->set_rules('domisili_tinggal', 'Domisili Tinggal', 'required');

        if ($this->form_validation->run() == false) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_panggilan/edit', $data);
            $this->load->view('template/user_footer');
        } else {
            $upload_image = $_FILES['link_foto']['name'];
            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_foto = basename($upload_image, '.' . $ext);
                $nama_foto_baru = $nama_foto . '_' . time() . '.' . $ext;

                $config['upload_path'] = './asset/img/panggilan/';
                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048;
                $config['file_name'] = $nama_foto_baru;
                $config['overwrite'] = TRUE;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('link_foto')) {
                    $old_image = $data['panggilan']['link_foto'];
                    if ($old_image && file_exists(FCPATH . 'asset/img/panggilan/' . $old_image)) {
                        unlink(FCPATH . 'asset/img/panggilan/' . $old_image);
                    }
                    $new_img = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah foto: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_panggilan/edit/' . $id);
                }
            } else {
                $new_img = $data['panggilan']['link_foto'] ?? ''; // Gunakan existing atau default kosong
            }

            $data_update = [
                'nama_lengkap' => $this->input->post('nama_lengkap'),
                'nama_panggilan' => $this->input->post('nama_panggilan') ?? '',
                'tempat_lahir' => $this->input->post('tempat_lahir') ?? '',
                'tanggal_lahir' => $this->input->post('tanggal_lahir') ?? '',
                'tempat_tahbisan' => $this->input->post('tempat_tahbisan') ?? '',
                'tanggal_tahbisan' => $this->input->post('tanggal_tahbisan') ?? '',
                'nama_ayah' => $this->input->post('nama_ayah') ?? '',
                'nama_ibu' => $this->input->post('nama_ibu') ?? '',
                'domisili_tinggal' => $this->input->post('domisili_tinggal'),
                'deskripsi' => $this->input->post('deskripsi') ?? '',
                'link_foto' => $new_img,
                'tarekat' => $this->input->post('tarekat') ?? '',
                'jabatan' => $this->input->post('jabatan') ?? '',
                'alamat_tinggal' => $this->input->post('alamat_tinggal') ?? '',
                'tanggal_update' => date('Y-m-d H:i:s'),
                'role' => 0
            ];

            $this->db->where('id', $id);
            if ($this->db->update('panggilan_db', $data_update)) {
                $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data panggilan berhasil diperbarui!</div>');
            } else {
                $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal memperbarui data!</div>');
            }
            redirect('d_panggilan');
        }
    }
}