<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class D_Lingkungan extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('session');

        if (!$this->session->userdata('email')) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Silakan login terlebih dahulu!</div>');
            redirect('auth');
        }
    }

    public function index() {
        $data['title'] = 'Nama Lingkungan & Stasi';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

        if (!$data['user']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengguna tidak ditemukan! Silakan login ulang.</div>');
            redirect('auth');
        }

        $data['search'] = $this->input->get('search', true);
        $data['status'] = $this->input->get('status', true);
        $this->load->model('Lingkungan_model', 'lingkungan');

        if ($data['user']['role_id'] == 1) {
            $data['lingkungan'] = $this->lingkungan->getLingkungan($data['search'], $data['status'] === 'all' ? null : $data['status']);
        } else {
            $data['lingkungan'] = $this->lingkungan->getLingkunganByUser($data['user']['id'], $data['search'], $data['status'] === 'all' ? null : $data['status']);
        }

        $this->load->view('template/user_header', $data);
        $this->load->view('template/sidebar', $data);
        $this->load->view('template/topbar', $data);
        $this->load->view('d_lingkungan/index', $data);
        $this->load->view('template/user_footer');
    }

    public function tambah() {
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

        $this->form_validation->set_rules('kategori', 'Kategori', 'required');
        $this->form_validation->set_rules('nama_pelindung', 'Nama Pelindung', 'required');
        $this->form_validation->set_rules('lokasi', 'Lokasi', 'required');
        // Wilayah dan id_ketua tidak required lagi
        $this->form_validation->set_rules('nama_ketua', 'Nama Ketua', 'required');

        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Field wajib harus diisi!</div>');
            redirect('d_lingkungan');
        } else {
            $upload_image = $_FILES['gambar_gereja']['name'];
            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_gambar = basename($upload_image, '.' . $ext);
                $nama_gambar_baru = $nama_gambar . '_' . time() . '.' . $ext;

                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048;
                $config['upload_path'] = './asset/img/lingkungan/';
                $config['file_name'] = $nama_gambar_baru;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('gambar_gereja')) {
                    $new_img = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah gambar: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_lingkungan');
                }
            } else {
                $new_img = '';
            }

            $data_insert = [
                'kategori' => $this->input->post('kategori', true),
                'nama_pelindung' => $this->input->post('nama_pelindung', true),
                'lokasi' => $this->input->post('lokasi', true),
                'wilayah' => $this->input->post('wilayah', true) ?: '', // Kosong jika tidak diisi
                'role' => 0,
                'nama_ketua' => $this->input->post('nama_ketua', true),
                'id_ketua' => $this->input->post('id_ketua', true) ?: 0, // Null jika tidak diisi
                'gambar_gereja' => $new_img
            ];
            $this->db->insert('lingk_stasi', $data_insert);

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data Lingkungan/Stasi berhasil ditambahkan!</div>');
            redirect('d_lingkungan');
        }
    }

    public function publish($id) {
        $user = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        if ($user['role_id'] != 1) {
            redirect('d_lingkungan');
        }

        $this->db->set('role', 1);
        $this->db->where('id', $id);
        $this->db->update('lingk_stasi');

        $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data berhasil dipublikasikan!</div>');
        redirect('d_lingkungan');
    }

    public function delete($id) {
        $lingkungan = $this->db->get_where('lingk_stasi', ['id' => $id])->row_array();

        if ($lingkungan) {
            if ($lingkungan['gambar_gereja'] != '' && file_exists(FCPATH . 'asset/img/lingkungan/' . $lingkungan['gambar_gereja'])) {
                unlink(FCPATH . 'asset/img/lingkungan/' . $lingkungan['gambar_gereja']);
            }

            $this->db->where('id', $id);
            $this->db->delete('lingk_stasi');

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data berhasil dihapus!</div>');
        } else {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Data tidak ditemukan!</div>');
        }

        redirect('d_lingkungan');
    }

    public function edit($id) {
        $data['title'] = 'Edit Lingkungan & Stasi';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    
        if (!$data['user']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengguna tidak ditemukan! Silakan login ulang.</div>');
            redirect('auth');
        }
    
        $this->load->model('Lingkungan_model', 'lingkungan');
        $data['lingk'] = $this->lingkungan->getLingkunganById($id);
        if (!$data['lingk']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Data tidak ditemukan!</div>');
            redirect('d_lingkungan');
        }
    
        $this->form_validation->set_rules('nama_ketua', 'Nama Ketua', 'required');
        // Hanya nama_ketua yang wajib, wilayah dan gambar_gereja opsional
    
        if ($this->form_validation->run() == false) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_lingkungan/edit', $data);
            $this->load->view('template/user_footer');
        } else {
            $upload_image = $_FILES['gambar_gereja']['name'];
    
            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_gambar = basename($upload_image, '.' . $ext);
                $nama_gambar_baru = $nama_gambar . '_' . time() . '.' . $ext;
    
                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048;
                $config['upload_path'] = './asset/img/lingkungan/';
                $config['file_name'] = $nama_gambar_baru;
    
                $this->load->library('upload', $config);
    
                if ($this->upload->do_upload('gambar_gereja')) {
                    $old_image = $data['lingk']['gambar_gereja'];
                    if ($old_image && file_exists(FCPATH . 'asset/img/lingkungan/' . $old_image)) {
                        unlink(FCPATH . 'asset/img/lingkungan/' . $old_image);
                    }
                    $new_img = $this->upload->data('file_name');
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah gambar: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_lingkungan/edit/' . $id);
                }
            } else {
                $new_img = $data['lingk']['gambar_gereja'];
            }
    
            $data_update = [
                'wilayah' => $this->input->post('wilayah', true) ?: '',
                'nama_ketua' => $this->input->post('nama_ketua', true),
                'role' => 0,
                'gambar_gereja' => $new_img
            ];
    
            $this->lingkungan->updateLingkungan($id, $data_update);
            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Data berhasil diperbarui!</div>');
            redirect('d_lingkungan');
        }
    }
}