<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class D_Kumpulandoa extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('session');
        $this->load->model('Doa_modal', 'doa');
    }

    public function index()
{
    // Cek apakah user sudah login
    if (!$this->session->userdata('email')) {
        $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Silakan login terlebih dahulu!</div>');
        redirect('auth');
    }

    // Ambil data user
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

    // Cek apakah user ada
    if (!$data['user']) {
        $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengguna tidak ditemukan! Silakan login ulang.</div>');
        $this->session->unset_userdata('email');
        redirect('auth');
    }

    // Cek apakah view utama ada
    $view_path = APPPATH . 'views/d_kumpulandoa/index.php';
    if (!file_exists($view_path)) {
        $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Halaman kumpulan doa tidak ditemukan!</div>');
        redirect('home'); // Redirect ke home jika view tidak ada
    }

    // Siapkan data
    $data['title'] = 'Kumpulan Doa';
    $search = $this->input->get('search', true);
    $status = $this->input->get('status', true);

    // Load model (pastikan model sudah ada)
    $this->load->model('Doa_model', 'doa');

    // Ambil data doa berdasarkan role
    if ($data['user']['role_id'] == 2) {
        $data['doa'] = $this->doa->getDoaByUser($data['user']['id'], $search, $status);
    } else {
        $data['doa'] = $this->doa->getDoa($search, $status);
    }

    $data['kategori_doa'] = $this->db->get_where('kategori_doa', ['role' => 1])->result_array();

    // Set rules validasi
    $this->form_validation->set_rules('judul', 'Judul', 'required|trim');
    $this->form_validation->set_rules('doa', 'Doa', 'required|trim');
    $this->form_validation->set_rules('kategori_doa', 'Kategori Doa', 'required|trim');

    // Proses request
    if ($this->input->post()) {
        if ($this->form_validation->run() == false) {
            // Jika validasi gagal
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_kumpulandoa/index', $data);
            $this->load->view('template/user_footer');
        } else {
            // Jika validasi sukses
            $data_insert = [
                'judul' => $this->input->post('judul', true),
                'doa' => $this->input->post('doa', true),
                'referensi' => $this->input->post('referensi', true),
                'kategori_doa' => $this->input->post('kategori_doa', true),
                'role' => 0,
                'id_user' => $data['user']['id']
            ];

            if ($this->db->insert('doa_db', $data_insert)) {
                $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Doa berhasil ditambahkan!</div>');
            } else {
                $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal menyimpan doa!</div>');
            }
            redirect('d_kumpulandoa');
        }
    } else {
        // Tampilan awal (GET request)
        $this->load->view('template/user_header', $data);
        $this->load->view('template/sidebar', $data);
        $this->load->view('template/topbar', $data);
        $this->load->view('d_kumpulandoa/index', $data);
        $this->load->view('template/user_footer');
    }
}

    public function publish($id) {
        $user = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        if ($user['role_id'] != 1) {
            redirect('d_kumpulandoa');
        }

        $this->db->set('role', 1);
        $this->db->where('id', $id);
        $this->db->update('doa_db');

        $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Doa berhasil dipublikasikan!</div>');
        redirect('d_kumpulandoa');
    }

    public function delete($id) {
        $doa = $this->db->get_where('doa_db', ['id' => $id])->row_array();

        if ($doa) {
            $this->db->where('id', $id);
            $this->db->delete('doa_db');

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Doa berhasil dihapus!</div>');
        } else {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Doa tidak ditemukan!</div>');
        }

        redirect('d_kumpulandoa');
    }

    public function add_kategori() {
        $this->form_validation->set_rules('kategori_doa', 'Kategori Doa', 'required|trim');

        if ($this->form_validation->run() == false) {
            redirect('d_kumpulandoa');
        } else {
            $kategori_doa = $this->input->post('kategori_doa', true);
            $data = [
                'nama' => htmlspecialchars($kategori_doa),
                'role' => 1
            ];

            $this->db->insert('kategori_doa', $data);

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Kategori doa berhasil ditambahkan!</div>');
            redirect('d_kumpulandoa');
        }
    }

    public function editdoa($id) {
        $data['title'] = 'Edit Doa';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['doa'] = $this->db->get_where('doa_db', ['id' => $id])->row_array();
        $data['kategori_doa'] = $this->db->get_where('kategori_doa', ['role' => 1])->result_array();
    
        if (!$data['doa']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Doa tidak ditemukan!</div>');
            redirect('d_kumpulandoa');
        }
    
        $this->form_validation->set_rules('judul', 'Judul', 'required');
        $this->form_validation->set_rules('doa', 'Doa', 'required');
        $this->form_validation->set_rules('kategori_doa', 'Kategori Doa', 'required');
    
        if ($this->form_validation->run() == false) {
            // Load halaman edit terpisah
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_kumpulandoa/edit_doa', $data);
            $this->load->view('template/user_footer');
        } else {
            $data = [
                'judul' => $this->input->post('judul'),
                'doa' => $this->input->post('doa'),
                'referensi' => $this->input->post('referensi'),
                'kategori_doa' => $this->input->post('kategori_doa'),
                'role' => 0 // Set ke pending setelah edit, sesuaikan jika ingin berbeda
            ];
    
            $this->db->where('id', $id);
            $this->db->update('doa_db', $data);
    
            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Doa berhasil diperbarui!</div>');
            redirect('d_kumpulandoa');
        }
    }
}