<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class D_Artikel extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_validation');
        $this->load->library('session');

        if (!$this->session->userdata('email')) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Silakan login terlebih dahulu!</div>');
            redirect('auth');
        }
    }

    public function index() {
        $data['title'] = 'Daftar Artikel';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

        if (!$data['user']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengguna tidak ditemukan! Silakan login ulang.</div>');
            redirect('auth');
        }

        $data['search'] = $this->input->get('search', true);
        $data['status'] = $this->input->get('status', true);
        $this->load->model('Artikel_model', 'artikel');

        if ($data['user']['role_id'] == 1) {
            $data['artikel'] = $this->artikel->getArtikel($data['search'], $data['status'] === 'all' ? null : $data['status']);
        } else {
            $data['artikel'] = $this->artikel->getArtikelByUser($data['user']['id'], $data['search'], $data['status'] === 'all' ? null : $data['status']);
        }

        $data['kategori'] = $this->db->get('kategori_artikel')->result_array();

        $this->form_validation->set_rules('judul', 'Judul', 'required');
        $this->form_validation->set_rules('isi', 'Isi', 'required');
        $this->form_validation->set_rules('kategori', 'Kategori', 'required');

        if ($this->input->post() && $this->form_validation->run() == false) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_artikel/index', $data);
            $this->load->view('template/user_footer');
        } elseif ($this->input->post()) {
            $upload_image = $_FILES['gambar']['name'];
            $penulis = $data['user']['name'];

            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_gambar = basename($upload_image, '.' . $ext);
                $nama_gambar_baru = $nama_gambar . '_' . time() . '.' . $ext;

                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048;
                $config['upload_path'] = './asset/img/artikel/';
                $config['file_name'] = $nama_gambar_baru;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('gambar')) {
                    $new_img = $this->upload->data('file_name');
                    $data_insert = [
                        'judul' => $this->input->post('judul', true),
                        'isi' => $this->input->post('isi', true),
                        'kategori' => $this->input->post('kategori', true),
                        'penulis' => $penulis,
                        'tanggal' => date('Y-m-d H:i:s'),
                        'role' => 0,
                        'linkg1' => $new_img,
                        'id_user' => $data['user']['id']
                    ];
                    $this->db->insert('artikel_db', $data_insert);
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah gambar: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_artikel');
                }
            } else {
                $data_insert = [
                    'judul' => $this->input->post('judul', true),
                    'isi' => $this->input->post('isi', true),
                    'kategori' => $this->input->post('kategori', true),
                    'penulis' => $penulis,
                    'tanggal' => date('Y-m-d H:i:s'),
                    'role' => 0,
                    'linkg1' => '',
                    'id_user' => $data['user']['id']
                ];
                $this->db->insert('artikel_db', $data_insert);
            }

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Artikel berhasil ditambahkan!</div>');
            redirect('d_artikel');
        } else {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_artikel/index', $data);
            $this->load->view('template/user_footer');
        }
    }

    public function publish($id) {
        $user = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        if ($user['role_id'] != 1) {
            redirect('d_artikel');
        }

        $this->db->set('role', 1);
        $this->db->where('id', $id);
        $this->db->update('artikel_db');

        $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Artikel berhasil dipublikasikan!</div>');
        redirect('d_artikel');
    }

    public function delete($id) {
        $artikel = $this->db->get_where('artikel_db', ['id' => $id])->row_array();

        if ($artikel) {
            if ($artikel['linkg1'] != '' && file_exists(FCPATH . 'asset/img/artikel/' . $artikel['linkg1'])) {
                unlink(FCPATH . 'asset/img/artikel/' . $artikel['linkg1']);
            }

            $this->db->where('id', $id);
            $this->db->delete('artikel_db');

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Artikel berhasil dihapus!</div>');
        } else {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Artikel tidak ditemukan!</div>');
        }

        redirect('d_artikel');
    }

    public function add_kategori() {
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        if ($data['user']['role_id'] != 1) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Anda tidak memiliki izin untuk menambah kategori!</div>');
            redirect('d_artikel');
        }

        $this->form_validation->set_rules('kategori', 'Kategori', 'required|trim');

        if ($this->form_validation->run() == false) {
            redirect('d_artikel');
        } else {
            $kategori = $this->input->post('kategori', true);
            $data = [
                'nama' => htmlspecialchars($kategori),
                'role' => 1
            ];
            $this->db->insert('kategori_artikel', $data);

            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Kategori berhasil ditambahkan!</div>');
            redirect('d_artikel');
        }
    }

    public function editartikel($id) {
        $data['title'] = 'Artikel Management';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();

        if (!$data['user']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Pengguna tidak ditemukan! Silakan login ulang.</div>');
            redirect('auth');
        }

        $this->load->model('Artikel_model', 'artikel');
        $data['art'] = $this->artikel->getArtikelById($id);
        if (!$data['art']) {
            $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Artikel tidak ditemukan!</div>');
            redirect('d_artikel');
        }

        $data['kategori'] = $this->db->get('kategori_artikel')->result_array();

        $this->form_validation->set_rules('judul', 'Judul', 'required');
        $this->form_validation->set_rules('isi', 'Isi', 'required');
        $this->form_validation->set_rules('kategori', 'Kategori', 'required');

        if ($this->form_validation->run() == false) {
            $this->load->view('template/user_header', $data);
            $this->load->view('template/sidebar', $data);
            $this->load->view('template/topbar', $data);
            $this->load->view('d_artikel/editartikel', $data);
            $this->load->view('template/user_footer');
        } else {
            $upload_image = $_FILES['gambar']['name'];

            if ($upload_image) {
                $ext = pathinfo($upload_image, PATHINFO_EXTENSION);
                $nama_gambar = basename($upload_image, '.' . $ext);
                $nama_gambar_baru = $nama_gambar . '_' . time() . '.' . $ext;

                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = 12048;
                $config['upload_path'] = './asset/img/artikel/';
                $config['file_name'] = $nama_gambar_baru;

                $this->load->library('upload', $config);

                if ($this->upload->do_upload('gambar')) {
                    $old_image = $data['art']['linkg1'];
                    if ($old_image && file_exists(FCPATH . 'asset/img/artikel/' . $old_image)) {
                        unlink(FCPATH . 'asset/img/artikel/' . $old_image);
                    }

                    $new_img = $this->upload->data('file_name');
                    $data_update = [
                        'judul' => $this->input->post('judul', true),
                        'isi' => $this->input->post('isi', true),
                        'tag' => $this->input->post('tag', true),
                        'kategori' => $this->input->post('kategori', true),
                        'tanggal' => date('Y-m-d H:i:s'),
                        'role' => 0,
                        'linkg1' => $new_img
                    ];
                } else {
                    $this->session->set_flashdata('message', '<div class="alert alert-danger" role="alert">Gagal mengunggah gambar: ' . $this->upload->display_errors() . '</div>');
                    redirect('d_artikel/editartikel/' . $id);
                }
            } else {
                $data_update = [
                    'judul' => $this->input->post('judul', true),
                    'isi' => $this->input->post('isi', true),
                    'tag' => $this->input->post('tag', true),
                    'kategori' => $this->input->post('kategori', true),
                    'tanggal' => date('Y-m-d H:i:s'),
                    'role' => 0,
                    'linkg1' => $data['art']['linkg1']
                ];
            }

            $this->artikel->updateArtikel($id, $data_update);
            $this->session->set_flashdata('message', '<div class="alert alert-success" role="alert">Artikel berhasil diperbarui!</div>');
            redirect('d_artikel');
        }
    }
}